/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import org.neo4j.bolt.messaging.ResultConsumer;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;

public class ResultConsumerAdaptor
implements ResultConsumer {
    private final boolean pull;
    private final StateMachineContext context;

    ResultConsumerAdaptor(StateMachineContext context, boolean pull) {
        this.pull = pull;
        this.context = context;
    }

    @Override
    public boolean hasMore() {
        return false;
    }

    @Override
    public void consume(BoltResult boltResult) throws Throwable {
        if (this.pull) {
            this.context.connectionState().getResponseHandler().onPullRecords(boltResult, -1L);
        } else {
            this.context.connectionState().getResponseHandler().onDiscardRecords(boltResult, -1L);
        }
    }
}

