/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transaction;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.ResultConsumer;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.statemachine.StatementMetadata;
import org.neo4j.bolt.runtime.statemachine.StatementProcessor;
import org.neo4j.bolt.runtime.statemachine.impl.StatementProcessorProvider;
import org.neo4j.bolt.transaction.CleanUpConnectionContext;
import org.neo4j.bolt.transaction.CleanUpTransactionContext;
import org.neo4j.bolt.transaction.DefaultProgramResultReference;
import org.neo4j.bolt.transaction.InitializeContext;
import org.neo4j.bolt.transaction.ProgramResultReference;
import org.neo4j.bolt.transaction.ResultNotFoundException;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.bolt.transaction.TransactionNotFoundException;
import org.neo4j.bolt.transaction.TransactionStatus;
import org.neo4j.bolt.v4.messaging.DiscardResultConsumer;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.virtual.MapValue;

public class StatementProcessorTxManager
implements TransactionManager {
    private final Map<String, StatementProcessor> statementProcessors = new ConcurrentHashMap<String, StatementProcessor>();
    private final Map<String, StatementProcessorProvider> statementProcessorProviders = new ConcurrentHashMap<String, StatementProcessorProvider>();

    @Override
    public String begin(LoginContext loginContext, String defaultDb, List<Bookmark> bookmarks, boolean isReadOnly, Map<String, Object> transactionMetadata, Duration transactionTimeout, String connectionId) throws KernelException {
        String txId = UUID.randomUUID().toString();
        StatementProcessor newTxProcessor = this.retrieveStatementProcessor(connectionId, loginContext, defaultDb, txId);
        AccessMode accessMode = isReadOnly ? AccessMode.READ : AccessMode.WRITE;
        newTxProcessor.beginTransaction(bookmarks, transactionTimeout, accessMode, transactionMetadata);
        this.statementProcessors.put(txId, newTxProcessor);
        return txId;
    }

    @Override
    public Bookmark commit(String txId) throws KernelException, TransactionNotFoundException {
        Bookmark bookmark = this.retrieveTx(txId).commitTransaction();
        this.statementProcessors.remove(txId);
        return bookmark;
    }

    @Override
    public void rollback(String txId) throws TransactionNotFoundException {
        try {
            this.retrieveTx(txId).reset();
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.statementProcessors.remove(txId);
        }
    }

    @Override
    public StatementMetadata runQuery(String txReference, String cypherQuery, MapValue params) throws KernelException, TransactionNotFoundException {
        StatementProcessor statementProcessor = this.retrieveTx(txReference);
        return statementProcessor.run(cypherQuery, params);
    }

    @Override
    public ProgramResultReference runProgram(String programId, LoginContext loginContext, String defaultDb, String cypherProgram, MapValue params, List<Bookmark> bookmarks, boolean isReadOnly, Map<String, Object> programMetadata, Duration programTimeout, String connectionId) throws KernelException {
        StatementProcessor statementProcessor = this.retrieveStatementProcessor(connectionId, loginContext, defaultDb, programId);
        this.statementProcessors.put(programId, statementProcessor);
        AccessMode accessMode = isReadOnly ? AccessMode.READ : AccessMode.WRITE;
        StatementMetadata metadata = statementProcessor.run(cypherProgram, params, bookmarks, programTimeout, accessMode, programMetadata);
        return new DefaultProgramResultReference(programId, metadata);
    }

    @Override
    public Bookmark pullData(String txId, int statementId, long numberToPull, ResultConsumer recordConsumer) throws ResultNotFoundException, TransactionNotFoundException {
        return this.streamResults(txId, statementId, recordConsumer);
    }

    @Override
    public Bookmark discardData(String txId, int statementId, long numberToDiscard, ResultConsumer resultConsumer) throws ResultNotFoundException, TransactionNotFoundException {
        return this.streamResults(txId, statementId, resultConsumer);
    }

    @Override
    public void cancelData(String txId, int statementId) throws ResultNotFoundException, TransactionNotFoundException {
        this.discardData(txId, statementId, -1L, new DiscardResultConsumer(null, -1L));
    }

    @Override
    public void interrupt(String txReference) {
        if (txReference != null && this.statementProcessors.containsKey(txReference)) {
            this.statementProcessors.get(txReference).markCurrentTransactionForTermination();
        }
    }

    @Override
    public TransactionStatus transactionStatus(String txId) {
        if (this.statementProcessors.containsKey(txId)) {
            StatementProcessor tx = this.statementProcessors.get(txId);
            try {
                Status status = tx.validateTransaction();
                if (status != null) {
                    return new TransactionStatus(TransactionStatus.Value.INTERRUPTED, status);
                }
                if (tx.hasOpenStatement()) {
                    return new TransactionStatus(TransactionStatus.Value.IN_TRANSACTION_OPEN_STATEMENT);
                }
                return new TransactionStatus(TransactionStatus.Value.IN_TRANSACTION_NO_OPEN_STATEMENTS);
            }
            catch (KernelException ex) {
                throw new RuntimeException(ex);
            }
        }
        return new TransactionStatus(TransactionStatus.Value.CLOSED_OR_DOES_NOT_EXIST);
    }

    @Override
    public void cleanUp(CleanUpTransactionContext cleanUpTransactionContext) {
        this.statementProcessors.remove(cleanUpTransactionContext.transactionId());
    }

    @Override
    public void cleanUp(CleanUpConnectionContext cleanUpConnectionContext) {
        this.statementProcessorProviders.remove(cleanUpConnectionContext.connectionId());
    }

    @Override
    public void initialize(InitializeContext initializeContext) {
        this.statementProcessorProviders.computeIfAbsent(initializeContext.connectionId(), key -> initializeContext.statementProcessorProvider());
    }

    public void removeStatementProcessorProvider(String connectionId) {
        this.statementProcessorProviders.remove(connectionId);
    }

    @VisibleForTesting
    public int getCurrentNoOfOpenTx() {
        return this.statementProcessors.size();
    }

    private StatementProcessor retrieveTx(String txId) throws TransactionNotFoundException {
        StatementProcessor statementProcessor = this.statementProcessors.get(txId);
        if (statementProcessor == null) {
            throw new TransactionNotFoundException(txId);
        }
        return statementProcessor;
    }

    private StatementProcessor retrieveStatementProcessor(String connectionId, LoginContext loginContext, String databaseName, String txId) {
        StatementProcessor statementProcessor;
        try {
            StatementProcessorProvider statementProcessorProvider = this.retrieveStatementProcessorProvider(connectionId);
            statementProcessor = statementProcessorProvider.getStatementProcessor(loginContext, databaseName, txId);
        }
        catch (BoltIOException | BoltProtocolBreachFatality boltProtocolBreachFatality) {
            throw new RuntimeException(boltProtocolBreachFatality);
        }
        if (statementProcessor == null) {
            throw new RuntimeException("StatementProcessor for connectionId: " + connectionId + " not found.");
        }
        return statementProcessor;
    }

    private StatementProcessorProvider retrieveStatementProcessorProvider(String connectionId) {
        StatementProcessorProvider statementProcessorProvider = this.statementProcessorProviders.get(connectionId);
        if (statementProcessorProvider == null) {
            throw new RuntimeException("StatementProcessorProvider for connectionId: " + connectionId + " not found.");
        }
        return statementProcessorProvider;
    }

    private Bookmark streamResults(String txId, int statementId, ResultConsumer recordConsumer) throws TransactionNotFoundException, ResultNotFoundException {
        StatementProcessor statementProcessor = this.retrieveTx(txId);
        try {
            return statementProcessor.streamResult(statementId, recordConsumer);
        }
        catch (IllegalArgumentException ex) {
            throw new ResultNotFoundException(txId, statementId);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

