/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Clock;
import java.util.Objects;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.Logging;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DomainNameResolver;
import org.neo4j.driver.internal.async.connection.ChannelConnectedListener;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilder;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.driver.internal.async.connection.HandshakeCompletedListener;
import org.neo4j.driver.internal.async.connection.NettyChannelInitializer;
import org.neo4j.driver.internal.async.connection.NettyDomainNameResolverGroup;
import org.neo4j.driver.internal.async.inbound.ConnectTimeoutHandler;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.security.SecurityPlan;

public class ChannelConnectorImpl
implements ChannelConnector {
    private final String userAgent;
    private final AuthTokenManager authTokenManager;
    private final RoutingContext routingContext;
    private final SecurityPlan securityPlan;
    private final ChannelPipelineBuilder pipelineBuilder;
    private final int connectTimeoutMillis;
    private final Logging logging;
    private final Clock clock;
    private final DomainNameResolver domainNameResolver;
    private final AddressResolverGroup<InetSocketAddress> addressResolverGroup;
    private final NotificationConfig notificationConfig;

    public ChannelConnectorImpl(ConnectionSettings connectionSettings, SecurityPlan securityPlan, Logging logging, Clock clock, RoutingContext routingContext, DomainNameResolver domainNameResolver, NotificationConfig notificationConfig) {
        this(connectionSettings, securityPlan, new ChannelPipelineBuilderImpl(), logging, clock, routingContext, domainNameResolver, notificationConfig);
    }

    public ChannelConnectorImpl(ConnectionSettings connectionSettings, SecurityPlan securityPlan, ChannelPipelineBuilder pipelineBuilder, Logging logging, Clock clock, RoutingContext routingContext, DomainNameResolver domainNameResolver, NotificationConfig notificationConfig) {
        this.userAgent = connectionSettings.userAgent();
        this.authTokenManager = connectionSettings.authTokenProvider();
        this.routingContext = routingContext;
        this.connectTimeoutMillis = connectionSettings.connectTimeoutMillis();
        this.securityPlan = Objects.requireNonNull(securityPlan);
        this.pipelineBuilder = pipelineBuilder;
        this.logging = Objects.requireNonNull(logging);
        this.clock = Objects.requireNonNull(clock);
        this.domainNameResolver = Objects.requireNonNull(domainNameResolver);
        this.addressResolverGroup = new NettyDomainNameResolverGroup(this.domainNameResolver);
        this.notificationConfig = notificationConfig;
    }

    @Override
    public ChannelFuture connect(BoltServerAddress address, Bootstrap bootstrap) {
        InetSocketAddress socketAddress;
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeoutMillis);
        bootstrap.handler((ChannelHandler)new NettyChannelInitializer(address, this.securityPlan, this.connectTimeoutMillis, this.authTokenManager, this.clock, this.logging));
        bootstrap.resolver(this.addressResolverGroup);
        try {
            socketAddress = new InetSocketAddress(this.domainNameResolver.resolve(address.connectionHost())[0], address.port());
        }
        catch (Throwable t) {
            socketAddress = InetSocketAddress.createUnresolved(address.connectionHost(), address.port());
        }
        ChannelFuture channelConnected = bootstrap.connect((SocketAddress)socketAddress);
        Channel channel = channelConnected.channel();
        ChannelPromise handshakeCompleted = channel.newPromise();
        ChannelPromise connectionInitialized = channel.newPromise();
        this.installChannelConnectedListeners(address, channelConnected, handshakeCompleted);
        this.installHandshakeCompletedListeners(handshakeCompleted, connectionInitialized);
        return connectionInitialized;
    }

    private void installChannelConnectedListeners(BoltServerAddress address, ChannelFuture channelConnected, ChannelPromise handshakeCompleted) {
        ChannelPipeline pipeline = channelConnected.channel().pipeline();
        channelConnected.addListener(future -> pipeline.addFirst(new ChannelHandler[]{new ConnectTimeoutHandler(this.connectTimeoutMillis)}));
        channelConnected.addListener((GenericFutureListener)new ChannelConnectedListener(address, this.pipelineBuilder, handshakeCompleted, this.logging));
    }

    private void installHandshakeCompletedListeners(ChannelPromise handshakeCompleted, ChannelPromise connectionInitialized) {
        ChannelPipeline pipeline = handshakeCompleted.channel().pipeline();
        handshakeCompleted.addListener(future -> pipeline.remove(ConnectTimeoutHandler.class));
        handshakeCompleted.addListener((GenericFutureListener)new HandshakeCompletedListener(this.userAgent, this.routingContext, connectionInitialized, this.notificationConfig, this.clock));
    }
}

