/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import io.netty.channel.Channel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.handlers.ResetResponseHandler;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.logging.ChannelErrorLogger;
import org.neo4j.driver.internal.messaging.ResponseMessageHandler;
import org.neo4j.driver.internal.messaging.request.ResetMessage;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.ErrorUtil;

public class InboundMessageDispatcher
implements ResponseMessageHandler {
    private final Channel channel;
    private final Queue<ResponseHandler> handlers = new LinkedList<ResponseHandler>();
    private final Logger log;
    private final ChannelErrorLogger errorLog;
    private volatile boolean gracefullyClosed;
    private Throwable currentError;
    private boolean fatalErrorOccurred;
    private HandlerHook beforeLastHandlerHook;
    private ResponseHandler autoReadManagingHandler;

    public InboundMessageDispatcher(Channel channel, Logging logging) {
        this.channel = Objects.requireNonNull(channel);
        this.log = new ChannelActivityLogger(channel, logging, this.getClass());
        this.errorLog = new ChannelErrorLogger(channel, logging);
    }

    public void enqueue(ResponseHandler handler) {
        if (this.fatalErrorOccurred) {
            handler.onFailure(this.currentError);
        } else {
            this.handlers.add(handler);
            this.updateAutoReadManagingHandlerIfNeeded(handler);
        }
    }

    public void setBeforeLastHandlerHook(HandlerHook beforeLastHandlerHook) {
        if (!this.channel.eventLoop().inEventLoop()) {
            throw new IllegalStateException("This method may only be called in the EventLoop");
        }
        this.beforeLastHandlerHook = beforeLastHandlerHook;
    }

    public int queuedHandlersCount() {
        return this.handlers.size();
    }

    @Override
    public void handleSuccessMessage(Map<String, Value> meta) {
        this.log.debug("S: SUCCESS %s", meta);
        this.invokeBeforeLastHandlerHook(HandlerHook.MessageType.SUCCESS);
        ResponseHandler handler = this.removeHandler();
        handler.onSuccess(meta);
    }

    @Override
    public void handleRecordMessage(Value[] fields) {
        ResponseHandler handler;
        if (this.log.isDebugEnabled()) {
            this.log.debug("S: RECORD %s", Arrays.toString(fields));
        }
        if ((handler = this.handlers.peek()) == null) {
            throw new IllegalStateException("No handler exists to handle RECORD message with fields: " + Arrays.toString(fields));
        }
        handler.onRecord(fields);
    }

    @Override
    public void handleFailureMessage(String code, String message) {
        this.log.debug("S: FAILURE %s \"%s\"", code, message);
        this.currentError = ErrorUtil.newNeo4jError(code, message);
        if (ErrorUtil.isFatal(this.currentError)) {
            this.channel.pipeline().fireExceptionCaught(this.currentError);
            return;
        }
        Throwable currentError = this.currentError;
        if (currentError instanceof AuthorizationExpiredException) {
            ChannelAttributes.authorizationStateListener(this.channel).onExpired((AuthorizationExpiredException)currentError, this.channel);
        } else {
            this.enqueue(new ResetResponseHandler(this));
            this.channel.writeAndFlush((Object)ResetMessage.RESET, this.channel.voidPromise());
        }
        this.invokeBeforeLastHandlerHook(HandlerHook.MessageType.FAILURE);
        ResponseHandler handler = this.removeHandler();
        handler.onFailure(currentError);
    }

    @Override
    public void handleIgnoredMessage() {
        Throwable error;
        this.log.debug("S: IGNORED", new Object[0]);
        ResponseHandler handler = this.removeHandler();
        if (this.currentError != null) {
            error = this.currentError;
        } else {
            this.log.warn("Received IGNORED message for handler %s but error is missing and RESET is not in progress. Current handlers %s", handler, this.handlers);
            error = new ClientException("Database ignored the request");
        }
        handler.onFailure(error);
    }

    public void handleChannelInactive(Throwable cause) {
        if (!this.gracefullyClosed) {
            this.handleChannelError(cause);
        } else {
            this.channel.close();
        }
    }

    public void handleChannelError(Throwable error) {
        if (this.currentError != null) {
            ErrorUtil.addSuppressed(this.currentError, error);
        } else {
            this.currentError = error;
        }
        this.fatalErrorOccurred = true;
        while (!this.handlers.isEmpty()) {
            ResponseHandler handler = this.removeHandler();
            handler.onFailure(this.currentError);
        }
        this.errorLog.traceOrDebug("Closing channel because of a failure", error);
        this.channel.close();
    }

    public void clearCurrentError() {
        this.currentError = null;
    }

    public Throwable currentError() {
        return this.currentError;
    }

    public boolean fatalErrorOccurred() {
        return this.fatalErrorOccurred;
    }

    public void prepareToCloseChannel() {
        this.gracefullyClosed = true;
    }

    ResponseHandler autoReadManagingHandler() {
        return this.autoReadManagingHandler;
    }

    private ResponseHandler removeHandler() {
        ResponseHandler handler = this.handlers.remove();
        if (handler == this.autoReadManagingHandler) {
            this.updateAutoReadManagingHandler(null);
        }
        return handler;
    }

    private void updateAutoReadManagingHandlerIfNeeded(ResponseHandler handler) {
        if (handler.canManageAutoRead()) {
            this.updateAutoReadManagingHandler(handler);
        }
    }

    private void updateAutoReadManagingHandler(ResponseHandler newHandler) {
        if (this.autoReadManagingHandler != null) {
            this.autoReadManagingHandler.disableAutoReadManagement();
            this.channel.config().setAutoRead(true);
        }
        this.autoReadManagingHandler = newHandler;
    }

    private void invokeBeforeLastHandlerHook(HandlerHook.MessageType messageType) {
        if (this.handlers.size() == 1 && this.beforeLastHandlerHook != null) {
            this.beforeLastHandlerHook.run(messageType);
        }
    }

    Logger getLog() {
        return this.log;
    }

    Logger getErrorLog() {
        return this.errorLog;
    }

    public static interface HandlerHook {
        public void run(MessageType var1);

        public static enum MessageType {
            SUCCESS,
            FAILURE;

        }
    }
}

