/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import java.util.Objects;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.messaging.BoltProtocol;

public class HandshakeCompletedListener
implements ChannelFutureListener {
    private final String userAgent;
    private final AuthToken authToken;
    private final RoutingContext routingContext;
    private final ChannelPromise connectionInitializedPromise;
    private final NotificationConfig notificationConfig;

    public HandshakeCompletedListener(String userAgent, AuthToken authToken, RoutingContext routingContext, ChannelPromise connectionInitializedPromise, NotificationConfig notificationConfig) {
        this.userAgent = Objects.requireNonNull(userAgent);
        this.authToken = Objects.requireNonNull(authToken);
        this.routingContext = routingContext;
        this.connectionInitializedPromise = Objects.requireNonNull(connectionInitializedPromise);
        this.notificationConfig = notificationConfig;
    }

    public void operationComplete(ChannelFuture future) {
        if (future.isSuccess()) {
            BoltProtocol protocol = BoltProtocol.forChannel(future.channel());
            protocol.initializeChannel(this.userAgent, this.authToken, this.routingContext, this.connectionInitializedPromise, this.notificationConfig);
        } else {
            this.connectionInitializedPromise.setFailure(future.cause());
        }
    }
}

