/*
 * Copyright (c) 2002-2020 "Neo4j,"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.neo4j.driver.exceptions;

/**
 * A <em>ClientException</em> indicates that the client has carried out an operation incorrectly.
 * The error code provided can be used to determine further detail for the problem.
 * @since 1.0
 */
public class ClientException extends Neo4jException
{
    public ClientException( String message )
    {
        super( message );
    }

    public ClientException( String message, Throwable cause )
    {
        super( message, cause );
    }

    public ClientException( String code, String message )
    {
        super( code, message );
    }
}
