/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.bytedeco.cpython.PyObject;
import org.bytedeco.cpython.global.python;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.python4j.NoneType;
import org.nd4j.python4j.Python;
import org.nd4j.python4j.PythonException;
import org.nd4j.python4j.PythonGC;
import org.nd4j.python4j.PythonGIL;
import org.nd4j.python4j.PythonObject;
import org.nd4j.python4j.PythonType;

public class PythonTypes {
    public static final PythonType<String> STR = new PythonType<String>("str", String.class){

        @Override
        public String adapt(Object javaObject) {
            if (javaObject instanceof String) {
                return (String)javaObject;
            }
            throw new PythonException("Cannot cast object of type " + javaObject.getClass().getName() + " to String");
        }

        @Override
        public String toJava(PythonObject pythonObject) {
            PythonGIL.assertThreadSafe();
            PyObject repr = python.PyObject_Str((PyObject)pythonObject.getNativePythonObject());
            PyObject str = python.PyUnicode_AsEncodedString((PyObject)repr, (String)"utf-8", (String)"~E~");
            String jstr = python.PyBytes_AsString((PyObject)str).getString();
            python.Py_DecRef((PyObject)repr);
            python.Py_DecRef((PyObject)str);
            return jstr;
        }

        @Override
        public PythonObject toPython(String javaObject) {
            return new PythonObject(python.PyUnicode_FromString((String)javaObject));
        }
    };
    public static final PythonType<Long> INT = new PythonType<Long>("int", Long.class){

        @Override
        public Long adapt(Object javaObject) {
            if (javaObject instanceof Number) {
                return ((Number)javaObject).longValue();
            }
            throw new PythonException("Cannot cast object of type " + javaObject.getClass().getName() + " to Long");
        }

        @Override
        public Long toJava(PythonObject pythonObject) {
            PythonGIL.assertThreadSafe();
            long val = python.PyLong_AsLong((PyObject)pythonObject.getNativePythonObject());
            if (val == -1L && python.PyErr_Occurred() != null) {
                throw new PythonException("Could not convert value to int: " + pythonObject.toString());
            }
            return val;
        }

        @Override
        public boolean accepts(Object javaObject) {
            return javaObject instanceof Integer || javaObject instanceof Long;
        }

        @Override
        public PythonObject toPython(Long javaObject) {
            return new PythonObject(python.PyLong_FromLong((long)javaObject));
        }
    };
    public static final PythonType<Double> FLOAT = new PythonType<Double>("float", Double.class){

        @Override
        public Double adapt(Object javaObject) {
            if (javaObject instanceof Number) {
                return ((Number)javaObject).doubleValue();
            }
            throw new PythonException("Cannot cast object of type " + javaObject.getClass().getName() + " to Long");
        }

        @Override
        public Double toJava(PythonObject pythonObject) {
            PythonGIL.assertThreadSafe();
            double val = python.PyFloat_AsDouble((PyObject)pythonObject.getNativePythonObject());
            if (val == -1.0 && python.PyErr_Occurred() != null) {
                throw new PythonException("Could not convert value to float: " + pythonObject.toString());
            }
            return val;
        }

        @Override
        public boolean accepts(Object javaObject) {
            return javaObject instanceof Float || javaObject instanceof Double;
        }

        @Override
        public PythonObject toPython(Double javaObject) {
            return new PythonObject(python.PyFloat_FromDouble((double)javaObject));
        }
    };
    public static final PythonType<Boolean> BOOL = new PythonType<Boolean>("bool", Boolean.class){

        @Override
        public Boolean adapt(Object javaObject) {
            if (javaObject instanceof Boolean) {
                return (Boolean)javaObject;
            }
            throw new PythonException("Cannot cast object of type " + javaObject.getClass().getName() + " to Boolean");
        }

        @Override
        public Boolean toJava(PythonObject pythonObject) {
            PythonGIL.assertThreadSafe();
            PyObject builtins = python.PyImport_ImportModule((String)"builtins");
            PyObject boolF = python.PyObject_GetAttrString((PyObject)builtins, (String)"bool");
            PythonObject bool = new PythonObject(boolF, false).call(pythonObject);
            boolean ret = python.PyLong_AsLong((PyObject)bool.getNativePythonObject()) > 0L;
            bool.del();
            python.Py_DecRef((PyObject)boolF);
            python.Py_DecRef((PyObject)builtins);
            return ret;
        }

        @Override
        public PythonObject toPython(Boolean javaObject) {
            return new PythonObject(python.PyBool_FromLong((long)(javaObject != false ? 1L : 0L)));
        }
    };
    public static final PythonType<List> LIST = new PythonType<List>("list", List.class){

        @Override
        public boolean accepts(Object javaObject) {
            return javaObject instanceof List || javaObject.getClass().isArray();
        }

        @Override
        public List adapt(Object javaObject) {
            if (javaObject instanceof List) {
                return (List)javaObject;
            }
            if (javaObject.getClass().isArray()) {
                ArrayList<Serializable> ret = new ArrayList<Serializable>();
                if (javaObject instanceof Object[]) {
                    Object[] arr = (Object[])javaObject;
                    return new ArrayList<Object>(Arrays.asList(arr));
                }
                if (javaObject instanceof short[]) {
                    short[] arr;
                    for (short x : arr = (short[])javaObject) {
                        ret.add(Short.valueOf(x));
                    }
                    return ret;
                }
                if (javaObject instanceof int[]) {
                    int[] arr;
                    for (int x : arr = (int[])javaObject) {
                        ret.add(Integer.valueOf(x));
                    }
                    return ret;
                }
                if (javaObject instanceof byte[]) {
                    byte[] arr;
                    for (byte x : arr = (byte[])javaObject) {
                        ret.add(Integer.valueOf(x & 0xFF));
                    }
                    return ret;
                }
                if (javaObject instanceof long[]) {
                    long[] arr;
                    for (long x : arr = (long[])javaObject) {
                        ret.add(Long.valueOf(x));
                    }
                    return ret;
                }
                if (javaObject instanceof float[]) {
                    float[] arr;
                    for (float x : arr = (float[])javaObject) {
                        ret.add(Float.valueOf(x));
                    }
                    return ret;
                }
                if (javaObject instanceof double[]) {
                    double[] arr;
                    for (double x : arr = (double[])javaObject) {
                        ret.add(Double.valueOf(x));
                    }
                    return ret;
                }
                if (javaObject instanceof boolean[]) {
                    boolean[] arr;
                    for (boolean x : arr = (boolean[])javaObject) {
                        ret.add(Boolean.valueOf(x));
                    }
                    return ret;
                }
                throw new PythonException("Unsupported array type: " + javaObject.getClass().toString());
            }
            throw new PythonException("Cannot cast object of type " + javaObject.getClass().getName() + " to List");
        }

        @Override
        public List toJava(PythonObject pythonObject) {
            PythonGIL.assertThreadSafe();
            ArrayList ret = new ArrayList();
            long n = python.PyObject_Size((PyObject)pythonObject.getNativePythonObject());
            if (n < 0L) {
                throw new PythonException("Object cannot be interpreted as a List");
            }
            for (long i = 0L; i < n; ++i) {
                PyObject pyIndex = python.PyLong_FromLong((long)i);
                PyObject pyItem = python.PyObject_GetItem((PyObject)pythonObject.getNativePythonObject(), (PyObject)pyIndex);
                python.Py_DecRef((PyObject)pyIndex);
                PythonType pyItemType = PythonTypes.getPythonTypeForPythonObject(new PythonObject(pyItem, false));
                ret.add(pyItemType.toJava(new PythonObject(pyItem, false)));
                python.Py_DecRef((PyObject)pyItem);
            }
            return ret;
        }

        @Override
        public PythonObject toPython(List javaObject) {
            PythonGIL.assertThreadSafe();
            PyObject pyList = python.PyList_New((long)javaObject.size());
            for (int i = 0; i < javaObject.size(); ++i) {
                boolean owned;
                PythonObject pyItem;
                Object item = javaObject.get(i);
                if (item instanceof PythonObject) {
                    pyItem = (PythonObject)item;
                    owned = false;
                } else if (item instanceof PyObject) {
                    pyItem = new PythonObject((PyObject)item, false);
                    owned = false;
                } else {
                    pyItem = PythonTypes.convert(item);
                    owned = true;
                }
                python.Py_IncRef((PyObject)pyItem.getNativePythonObject());
                python.PyList_SetItem((PyObject)pyList, (long)i, (PyObject)pyItem.getNativePythonObject());
                if (!owned) continue;
                pyItem.del();
            }
            return new PythonObject(pyList);
        }
    };
    public static final PythonType<Map> DICT = new PythonType<Map>("dict", Map.class){

        @Override
        public Map adapt(Object javaObject) {
            if (javaObject instanceof Map) {
                return (Map)javaObject;
            }
            throw new PythonException("Cannot cast object of type " + javaObject.getClass().getName() + " to Map");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map toJava(PythonObject pythonObject) {
            PythonGIL.assertThreadSafe();
            HashMap ret = new HashMap();
            PyObject dictType = new PyObject((Pointer)python.PyDict_Type());
            if (python.PyObject_IsInstance((PyObject)pythonObject.getNativePythonObject(), (PyObject)dictType) != 1) {
                throw new PythonException("Expected dict, received: " + pythonObject.toString());
            }
            PyObject keys = python.PyDict_Keys((PyObject)pythonObject.getNativePythonObject());
            PyObject keysIter = python.PyObject_GetIter((PyObject)keys);
            PyObject vals = python.PyDict_Values((PyObject)pythonObject.getNativePythonObject());
            PyObject valsIter = python.PyObject_GetIter((PyObject)vals);
            try {
                long n = python.PyObject_Size((PyObject)pythonObject.getNativePythonObject());
                for (long i = 0L; i < n; ++i) {
                    PythonObject pyKey = new PythonObject(python.PyIter_Next((PyObject)keysIter), false);
                    PythonObject pyVal = new PythonObject(python.PyIter_Next((PyObject)valsIter), false);
                    PythonType pyKeyType = PythonTypes.getPythonTypeForPythonObject(pyKey);
                    PythonType pyValType = PythonTypes.getPythonTypeForPythonObject(pyVal);
                    ret.put(pyKeyType.toJava(pyKey), pyValType.toJava(pyVal));
                    python.Py_DecRef((PyObject)pyKey.getNativePythonObject());
                    python.Py_DecRef((PyObject)pyVal.getNativePythonObject());
                }
            }
            finally {
                python.Py_DecRef((PyObject)keysIter);
                python.Py_DecRef((PyObject)valsIter);
                python.Py_DecRef((PyObject)keys);
                python.Py_DecRef((PyObject)vals);
            }
            return ret;
        }

        @Override
        public PythonObject toPython(Map javaObject) {
            PythonGIL.assertThreadSafe();
            PyObject pyDict = python.PyDict_New();
            for (Object k : javaObject.keySet()) {
                PythonObject pyKey = k instanceof PythonObject ? (PythonObject)k : (k instanceof PyObject ? new PythonObject((PyObject)k) : PythonTypes.convert(k));
                Object v = javaObject.get(k);
                PythonObject pyVal = v instanceof PythonObject ? (PythonObject)v : (v instanceof PyObject ? new PythonObject((PyObject)v) : PythonTypes.convert(v));
                int errCode = python.PyDict_SetItem((PyObject)pyDict, (PyObject)pyKey.getNativePythonObject(), (PyObject)pyVal.getNativePythonObject());
                if (errCode != 0) {
                    String keyStr = pyKey.toString();
                    pyKey.del();
                    pyVal.del();
                    throw new PythonException("Unable to create python dictionary. Unhashable key: " + keyStr);
                }
                pyKey.del();
                pyVal.del();
            }
            return new PythonObject(pyDict);
        }
    };
    public static final PythonType<byte[]> BYTES = new PythonType<byte[]>("bytes", byte[].class){

        @Override
        public byte[] toJava(PythonObject pythonObject) {
            try (PythonGC gc = PythonGC.watch();){
                if (!Python.isinstance(pythonObject, Python.bytesType())) {
                    throw new PythonException("Expected bytes. Received: " + pythonObject);
                }
                PythonObject pySize = Python.len(pythonObject);
                byte[] ret = new byte[pySize.toInt()];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = (byte)pythonObject.get(i).toInt();
                }
                byte[] byArray = ret;
                return byArray;
            }
        }

        @Override
        public PythonObject toPython(byte[] javaObject) {
            try (PythonGC gc = PythonGC.watch();){
                PythonObject ret = Python.bytes(LIST.toPython(LIST.adapt(javaObject)));
                PythonGC.keep(ret);
                PythonObject pythonObject = ret;
                return pythonObject;
            }
        }

        @Override
        public boolean accepts(Object javaObject) {
            return javaObject instanceof byte[];
        }

        @Override
        public byte[] adapt(Object javaObject) {
            if (javaObject instanceof byte[]) {
                return (byte[])javaObject;
            }
            throw new PythonException("Cannot cast object of type " + javaObject.getClass().getName() + " to byte[]");
        }
    };

    private static List<PythonType> getPrimitiveTypes() {
        return Arrays.asList(STR, INT, FLOAT, BOOL, BYTES, new NoneType());
    }

    private static List<PythonType> getCollectionTypes() {
        return Arrays.asList(LIST, DICT);
    }

    private static List<PythonType> getExternalTypes() {
        ArrayList<PythonType> ret = new ArrayList<PythonType>();
        ServiceLoader<PythonType> sl = ServiceLoader.load(PythonType.class);
        Iterator<PythonType> iter = sl.iterator();
        while (iter.hasNext()) {
            ret.add(iter.next());
        }
        return ret;
    }

    public static List<PythonType> get() {
        ArrayList<PythonType> ret = new ArrayList<PythonType>();
        ret.addAll(PythonTypes.getPrimitiveTypes());
        ret.addAll(PythonTypes.getCollectionTypes());
        ret.addAll(PythonTypes.getExternalTypes());
        return ret;
    }

    public static <T> PythonType<T> get(String name) {
        for (PythonType pt : PythonTypes.get()) {
            if (!pt.getName().equals(name)) continue;
            return pt;
        }
        throw new PythonException("Unknown python type: " + name);
    }

    public static PythonType getPythonTypeForJavaObject(Object javaObject) {
        for (PythonType pt : PythonTypes.get()) {
            if (!pt.accepts(javaObject)) continue;
            return pt;
        }
        throw new PythonException("Unable to find python type for java type: " + javaObject.getClass());
    }

    public static <T> PythonType<T> getPythonTypeForPythonObject(PythonObject pythonObject) {
        PyObject pyType = python.PyObject_Type((PyObject)pythonObject.getNativePythonObject());
        try {
            String pyTypeStr = STR.toJava(new PythonObject(pyType, false));
            for (PythonType pt : PythonTypes.get()) {
                String pyTypeStr2 = "<class '" + pt.getName() + "'>";
                if (pyTypeStr.equals(pyTypeStr2)) {
                    PythonType pythonType = pt;
                    return pythonType;
                }
                PythonGC gc = PythonGC.watch();
                try {
                    PythonObject pyType2 = pt.pythonType();
                    if (pyType2 == null || !Python.isinstance(pythonObject, pyType2)) continue;
                    PythonType pythonType = pt;
                    return pythonType;
                }
                finally {
                    if (gc == null) continue;
                    gc.close();
                }
            }
            throw new PythonException("Unable to find converter for python object of type " + pyTypeStr);
        }
        finally {
            python.Py_DecRef((PyObject)pyType);
        }
    }

    public static PythonObject convert(Object javaObject) {
        PythonType pt = PythonTypes.getPythonTypeForJavaObject(javaObject);
        return pt.toPython(pt.adapt(javaObject));
    }
}

