/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import java.util.concurrent.atomic.AtomicBoolean;
import org.bytedeco.cpython.PyThreadState;
import org.bytedeco.cpython.global.python;
import org.nd4j.python4j.PythonConstants;
import org.nd4j.python4j.PythonExecutioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonGIL
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PythonGIL.class);
    private static final AtomicBoolean acquired = new AtomicBoolean();
    private boolean acquiredByMe = false;
    private static long defaultThreadId = -1L;
    private int gilState;
    private static PyThreadState mainThreadState;
    private static long mainThreadId;

    public static synchronized void setMainThreadState() {
        if (mainThreadId < 0L && mainThreadState != null) {
            mainThreadState = python.PyThreadState_Get();
            mainThreadId = Thread.currentThread().getId();
        }
    }

    public static void assertThreadSafe() {
        if (acquired.get()) {
            return;
        }
        if (defaultThreadId == -1L) {
            defaultThreadId = Thread.currentThread().getId();
        } else if (defaultThreadId != Thread.currentThread().getId()) {
            throw new RuntimeException("Attempt to use Python4j from multiple threads without acquiring GIL. Enclose your code in a try(PythonGIL gil = PythonGIL.lock()){...} block to ensure that GIL is acquired in multi-threaded environments.");
        }
        if (!acquired.get()) {
            throw new IllegalStateException("Execution happening outside of GIL. Please use PythonExecutioner within a GIL block by wrapping it in a call via: try(PythonGIL gil = PythonGIL.lock()) { .. }");
        }
    }

    private PythonGIL() {
        log.debug("Acquiring GIL on " + Thread.currentThread().getId());
        acquired.set(true);
        this.acquiredByMe = true;
        this.acquire();
    }

    @Override
    public synchronized void close() {
        if (this.acquiredByMe) {
            this.release();
            log.info("Releasing GIL on thread " + Thread.currentThread().getId());
            acquired.set(false);
            this.acquiredByMe = false;
        } else {
            log.info("Attempted to release GIL without having acquired GIL on thread " + Thread.currentThread().getId());
        }
    }

    public static synchronized PythonGIL lock() {
        return new PythonGIL();
    }

    private synchronized void acquire() {
        if (Thread.currentThread().getId() != mainThreadId) {
            log.info("Pre Gil State ensure for thread " + Thread.currentThread().getId());
            this.gilState = python.PyGILState_Ensure();
            log.info("Thread " + Thread.currentThread().getId() + " acquired GIL");
        } else if (python._Py_IsFinalizing() != 1 && PythonConstants.releaseGilAutomatically()) {
            python.PyEval_RestoreThread((PyThreadState)mainThreadState);
        }
    }

    private void release() {
        if (Thread.currentThread().getId() != mainThreadId) {
            log.debug("Pre gil state release for thread " + Thread.currentThread().getId());
            if (PythonConstants.releaseGilAutomatically()) {
                python.PyGILState_Release((int)this.gilState);
            }
        } else if (python._Py_IsFinalizing() != 1 && PythonConstants.releaseGilAutomatically()) {
            python.PyEval_RestoreThread((PyThreadState)mainThreadState);
        }
    }

    public static boolean locked() {
        return acquired.get();
    }

    static {
        mainThreadId = -1L;
        new PythonExecutioner();
    }
}

