/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.v2.chunks.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.nd4j.common.primitives.AtomicBoolean;
import org.nd4j.common.util.SerializationUtils;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.parameterserver.distributed.v2.chunks.ChunksTracker;
import org.nd4j.parameterserver.distributed.v2.chunks.VoidChunk;
import org.nd4j.parameterserver.distributed.v2.messages.VoidMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InmemoryChunksTracker<T extends VoidMessage>
implements ChunksTracker<T> {
    private static final Logger log = LoggerFactory.getLogger(InmemoryChunksTracker.class);
    private final String originId;
    private final int numChunks;
    private Map<Integer, AtomicBoolean> map = new ConcurrentHashMap<Integer, AtomicBoolean>();
    private final byte[] buffer;
    private final long size;

    public InmemoryChunksTracker(VoidChunk chunk) {
        this.originId = chunk.getOriginalId();
        this.numChunks = chunk.getNumberOfChunks();
        if (chunk.getTotalSize() > Integer.MAX_VALUE) {
            throw new ND4JIllegalStateException("Total message size > Integer.MAX_VALUE");
        }
        this.size = chunk.getTotalSize();
        try {
            this.buffer = new byte[(int)this.size];
            for (int e = 0; e < this.numChunks; ++e) {
                this.map.put(e, new AtomicBoolean(false));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public boolean isComplete() {
        for (AtomicBoolean b : this.map.values()) {
            if (b.get()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean append(@NonNull VoidChunk chunk) {
        if (chunk == null) {
            throw new NullPointerException("chunk is marked non-null but is null");
        }
        AtomicBoolean b = this.map.get(chunk.getChunkId());
        if (b.get()) {
            return this.isComplete();
        }
        int offset = chunk.getChunkId() * chunk.getSplitSize();
        int cnt = 0;
        for (int e = offset; e < offset + chunk.getPayload().length; ++e) {
            this.buffer[e] = chunk.getPayload()[cnt++];
        }
        b.set(true);
        return this.isComplete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T getMessage() {
        if (!this.isComplete()) {
            throw new ND4JIllegalStateException("Message isn't ready for concatenation");
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(this.buffer);){
            VoidMessage voidMessage = (VoidMessage)SerializationUtils.deserialize((InputStream)bais);
            return (T)voidMessage;
        }
        catch (Exception e) {
            log.error("Exception: {}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public String getOriginId() {
        return this.originId;
    }
}

