/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas;

import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.cublas;
import org.bytedeco.javacpp.cuda;
import org.nd4j.linalg.factory.Nd4jBackend;
import org.nd4j.linalg.io.ClassPathResource;
import org.nd4j.linalg.io.Resource;
import org.nd4j.linalg.jcublas.JCublasNDArray;

public class JCublasBackend
extends Nd4jBackend {
    private static final String LINALG_PROPS = "/nd4j-jcublas.properties";

    public boolean isAvailable() {
        try {
            if (!this.canRun()) {
                return false;
            }
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean canRun() {
        int[] count = new int[]{0};
        cuda.cudaGetDeviceCount((int[])count);
        if (count[0] <= 0) {
            throw new RuntimeException("No CUDA devices were found in system");
        }
        Loader.load(cublas.class);
        return true;
    }

    public boolean allowsOrder() {
        return false;
    }

    public int getPriority() {
        return BACKEND_PRIORITY_GPU;
    }

    public Resource getConfigurationResource() {
        return new ClassPathResource(LINALG_PROPS, JCublasBackend.class.getClassLoader());
    }

    public Class getNDArrayClass() {
        return JCublasNDArray.class;
    }
}

