/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.cdi.Mapper;
import org.mybatis.cdi.MyBatisBean;
import org.mybatis.cdi.MybatisCdiConfigurationException;
import org.mybatis.cdi.SessionFactoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MybatisExtension.class.getName());
    private final Set<BeanKey> sessionProducers = new HashSet<BeanKey>();
    private final Set<Type> mapperTypes = new HashSet<Type>();
    private final Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();

    protected <T> void processAnnotatedType(@Observes @WithAnnotations(value={Mapper.class}) ProcessAnnotatedType<T> pat) {
        AnnotatedType at = pat.getAnnotatedType();
        if (at.isAnnotationPresent(Mapper.class)) {
            LOGGER.info("MyBatis CDI Module - Found class with @Mapper-annotation: {}", (Object)at.getJavaClass().getSimpleName());
            this.mapperTypes.add(at.getBaseType());
        }
    }

    protected <T, X> void processProducer(@Observes ProcessProducer<T, X> pp) {
        AnnotatedMember am = pp.getAnnotatedMember();
        boolean isAnnotated = am.isAnnotationPresent(SessionFactoryProvider.class);
        boolean isSqlSessionFactory = am.getBaseType().equals(SqlSessionFactory.class);
        String logData = String.join((CharSequence)".", am.getJavaMember().getDeclaringClass().getSimpleName(), am.getJavaMember().getName());
        if (isAnnotated) {
            if (isSqlSessionFactory) {
                LOGGER.info("MyBatis CDI Module - SqlSessionFactory producer {}", (Object)logData);
                this.sessionProducers.add(new BeanKey(SqlSession.class, am.getAnnotations()));
            } else {
                LOGGER.error("MyBatis CDI Module - Invalid return type (Must be SqlSessionFactory): {}", (Object)logData);
                pp.addDefinitionError((Throwable)new MybatisCdiConfigurationException(String.format("SessionFactoryProvider producers must return SqlSessionFactory (%s)", logData)));
            }
        } else if (isSqlSessionFactory) {
            LOGGER.warn("MyBatis CDI Module - Ignored SqlSessionFactory producer because it is not annotated with @SessionFactoryProvider: {}", (Object)logData);
        }
    }

    protected <X> void processInjectionTarget(@Observes ProcessInjectionTarget<X> event) {
        InjectionTarget it = event.getInjectionTarget();
        this.injectionPoints.addAll(it.getInjectionPoints());
    }

    protected void afterBeanDiscovery(@Observes AfterBeanDiscovery abd) {
        LOGGER.info("MyBatis CDI Module - Activated");
        HashSet<BeanKey> mappers = new HashSet<BeanKey>();
        HashSet<BeanKey> sessionTargets = new HashSet<BeanKey>();
        for (InjectionPoint ip : this.injectionPoints) {
            if (this.mapperTypes.contains(ip.getAnnotated().getBaseType())) {
                LOGGER.info("MyBatis CDI Module - Found a bean, which needs a Mapper {}", (Object)ip.getAnnotated().getBaseType());
                mappers.add(new BeanKey((Class)ip.getAnnotated().getBaseType(), ip.getAnnotated().getAnnotations()));
                continue;
            }
            if (!SqlSession.class.equals((Object)ip.getAnnotated().getBaseType())) continue;
            sessionTargets.add(new BeanKey((Class)ip.getAnnotated().getBaseType(), ip.getAnnotated().getAnnotations()));
        }
        this.injectionPoints.clear();
        for (BeanKey key : mappers) {
            LOGGER.info("MyBatis CDI Module - Managed Mapper dependency: {}, {}", (Object)key.getKey(), (Object)key.type.getName());
            abd.addBean((Bean)key.createBean());
        }
        this.mapperTypes.clear();
        for (BeanKey key : this.sessionProducers) {
            LOGGER.info("MyBatis CDI Module - Managed SqlSession: {}, {}", (Object)key.getKey(), (Object)key.type.getName());
            abd.addBean((Bean)key.createBean());
            sessionTargets.remove(key);
        }
        this.sessionProducers.clear();
        for (BeanKey key : sessionTargets) {
            LOGGER.warn("MyBatis CDI Module - Unmanaged SqlSession: {}, {}", (Object)key.getKey(), (Object)key.type.getName());
        }
    }

    private static final class BeanKey
    implements Comparable<BeanKey> {
        private final String key;
        private final List<Annotation> qualifiers;
        private final Class<Type> type;
        private final String sqlSessionManagerName;

        public BeanKey(Class<Type> type, Set<Annotation> annotations) {
            this.type = type;
            this.qualifiers = this.sort(this.filterQualifiers(annotations));
            StringBuilder sb = new StringBuilder();
            String name = null;
            sb.append(type.getName());
            for (Annotation q : this.qualifiers) {
                if (q instanceof Named) {
                    name = ((Named)q).value();
                    continue;
                }
                sb.append(".").append(q.annotationType().getSimpleName());
            }
            if (name != null) {
                sb.append("_").append(name);
            }
            this.key = sb.toString();
            this.sqlSessionManagerName = name;
        }

        private Set<Annotation> filterQualifiers(Set<Annotation> annotations) {
            HashSet<Annotation> set = new HashSet<Annotation>();
            for (Annotation a : annotations) {
                if (!a.annotationType().isAnnotationPresent(Qualifier.class)) continue;
                set.add(a);
            }
            return set;
        }

        private List<Annotation> sort(Set<Annotation> annotations) {
            ArrayList<Annotation> list = new ArrayList<Annotation>(annotations);
            Collections.sort(list, (a, b) -> a.getClass().getName().compareTo(b.getClass().getName()));
            return list;
        }

        @Override
        public int compareTo(BeanKey o) {
            return this.key.compareTo(o.key);
        }

        public int hashCode() {
            int hash = 3;
            return 43 * hash + (this.key != null ? this.key.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BeanKey other = (BeanKey)obj;
            return !(this.key != null ? !this.key.equals(other.key) : other.key != null);
        }

        public MyBatisBean createBean() {
            return new MyBatisBean(this.key, this.type, new HashSet<Annotation>(this.qualifiers), this.sqlSessionManagerName);
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.key;
        }
    }
}

