/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionManager;
import org.mybatis.cdi.CDIUtils;
import org.mybatis.cdi.SerializableMapperProxy;

public class MyBatisBean
implements Bean<Object>,
Serializable,
PassivationCapable {
    private static final long serialVersionUID = 1L;
    protected final Class<Type> type;
    protected final Set<Annotation> qualifiers;
    protected final String sqlSessionFactoryName;
    protected final String id;

    public MyBatisBean(String id, Class<Type> type, Set<Annotation> qualifiers, String sqlSessionFactoryName) {
        this.id = id;
        this.type = type;
        this.sqlSessionFactoryName = sqlSessionFactoryName;
        if (qualifiers == null || qualifiers.isEmpty()) {
            this.qualifiers = new HashSet<Annotation>();
            this.qualifiers.add((Annotation)((Object)new CDIUtils.SerializableDefaultAnnotationLiteral()));
            this.qualifiers.add((Annotation)((Object)new CDIUtils.SerializableAnyAnnotationLiteral()));
        } else {
            this.qualifiers = qualifiers;
        }
    }

    public Set<Type> getTypes() {
        HashSet<Type> types = new HashSet<Type>();
        types.add(this.type);
        return types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<Dependent> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Class<Type> getBeanClass() {
        return this.type;
    }

    public boolean isAlternative() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Object create(CreationalContext<Object> creationalContext) {
        if (SqlSession.class.equals(this.type)) {
            return this.findSqlSessionManager(creationalContext);
        }
        ErrorContext.instance().reset();
        return Proxy.newProxyInstance(SqlSessionFactory.class.getClassLoader(), new Class[]{this.type}, new SerializableMapperProxy<Object>(this, creationalContext));
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
        creationalContext.release();
    }

    private <T> SqlSessionManager findSqlSessionManager(CreationalContext<T> creationalContext) {
        SqlSessionFactory factory = CDIUtils.findSqlSessionFactory(this.sqlSessionFactoryName, this.qualifiers, creationalContext);
        return CDIUtils.getRegistry(creationalContext).getManager(factory);
    }

    public String getId() {
        return this.id;
    }
}

