/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.cdi.MybatisCdiConfigurationException;
import org.mybatis.cdi.SqlSessionManagerRegistry;

public final class CDIUtils {
    private CDIUtils() {
    }

    private static BeanManager getBeanManager() {
        return CDI.current().getBeanManager();
    }

    public static <T> SqlSessionManagerRegistry getRegistry(CreationalContext<T> creationalContext) {
        BeanManager beanManager = CDIUtils.getBeanManager();
        Iterator beans = beanManager.getBeans(SqlSessionManagerRegistry.class, new Annotation[0]).iterator();
        return (SqlSessionManagerRegistry)beanManager.getReference((Bean)beans.next(), SqlSessionManagerRegistry.class, creationalContext);
    }

    public static <T> SqlSessionFactory findSqlSessionFactory(String name, Set<Annotation> qualifiers, CreationalContext<T> creationalContext) {
        Set beans;
        BeanManager beanManager = CDIUtils.getBeanManager();
        Bean bean = beanManager.resolve(beans = name != null ? beanManager.getBeans(name) : beanManager.getBeans(SqlSessionFactory.class, qualifiers.toArray(new Annotation[0])));
        if (bean == null) {
            throw new MybatisCdiConfigurationException("There are no SqlSessionFactory producers properly configured.");
        }
        return (SqlSessionFactory)beanManager.getReference(bean, SqlSessionFactory.class, creationalContext);
    }

    public static class SerializableAnyAnnotationLiteral
    extends AnnotationLiteral<Any> {
        private static final long serialVersionUID = 1L;
    }

    public static class SerializableDefaultAnnotationLiteral
    extends AnnotationLiteral<Default> {
        private static final long serialVersionUID = 1L;
    }
}

