/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.unittesting.matchers.reasons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.mutabilitydetector.AnalysisResult;
import org.mutabilitydetector.MutableReasonDetail;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableList;
import org.mutabilitydetector.unittesting.internal.ReasonsFormatter;
import org.mutabilitydetector.unittesting.matchers.reasons.NoReasonsAllowed;

public final class WithAllowedReasonsMatcher
extends BaseMatcher<AnalysisResult> {
    private final Matcher<AnalysisResult> isImmutable;
    private final Iterable<Matcher<MutableReasonDetail>> allowedReasonMatchers;

    public static WithAllowedReasonsMatcher withAllowedReasons(Matcher<AnalysisResult> areImmutable, Iterable<Matcher<MutableReasonDetail>> allowing) {
        return new WithAllowedReasonsMatcher(areImmutable, ImmutableList.copyOf(allowing));
    }

    public static WithAllowedReasonsMatcher withNoAllowedReasons(Matcher<AnalysisResult> areImmutable) {
        NoReasonsAllowed noReasonsAllowed = NoReasonsAllowed.noReasonsAllowed();
        return WithAllowedReasonsMatcher.withAllowedReasons(areImmutable, Collections.singleton(noReasonsAllowed));
    }

    private WithAllowedReasonsMatcher(Matcher<AnalysisResult> isImmutable, Iterable<Matcher<MutableReasonDetail>> allowedReasons) {
        this.isImmutable = isImmutable;
        this.allowedReasonMatchers = allowedReasons;
    }

    public boolean matches(Object item) {
        return this.matchesSafely(this.checkIsValidToMatchOn(item), (Description)new StringDescription());
    }

    private AnalysisResult checkIsValidToMatchOn(Object item) {
        if (item == null || !(item instanceof AnalysisResult)) {
            throw new IllegalArgumentException("Trying to pass " + item + " where an " + AnalysisResult.class.getSimpleName() + " is required. " + "This is probably a programmer error, not your fault. Please file an issue. ");
        }
        return (AnalysisResult)item;
    }

    public void describeMismatch(Object item, Description description) {
        this.matchesSafely(this.checkIsValidToMatchOn(item), description);
    }

    private boolean matchesSafely(AnalysisResult analysisResult, Description mismatchDescription) {
        boolean matches = true;
        if (!this.isImmutable.matches((Object)analysisResult)) {
            matches = false;
            this.describeMismatchHandlingHamcrest1_1Matcher(analysisResult, mismatchDescription);
        }
        if (this.mutabilityReasonsHaveBeenAllowed(analysisResult.reasons, mismatchDescription)) {
            matches = true;
        }
        return matches;
    }

    private void describeMismatchHandlingHamcrest1_1Matcher(AnalysisResult analysisResult, Description mismatchDescription) {
        try {
            this.isImmutable.describeMismatch((Object)analysisResult, mismatchDescription);
        }
        catch (NoSuchMethodError e) {
            mismatchDescription.appendText(String.format("%s is actually %s%n", new Object[]{analysisResult.className.asString(), analysisResult.isImmutable}));
        }
    }

    private boolean mutabilityReasonsHaveBeenAllowed(Collection<MutableReasonDetail> reasons, Description mismatchDescription) {
        Collection<MutableReasonDetail> allowedReasons = this.collectAllowedReasons(reasons);
        ArrayList<MutableReasonDetail> unmatchedReasons = new ArrayList<MutableReasonDetail>(reasons);
        unmatchedReasons.removeAll(allowedReasons);
        boolean noAllowedReasonsProvided = allowedReasons.isEmpty();
        boolean allReasonsAllowed = unmatchedReasons.isEmpty();
        if (noAllowedReasonsProvided || !allReasonsAllowed) {
            this.describeMismatchedReasons(mismatchDescription, unmatchedReasons, allowedReasons);
            return false;
        }
        return true;
    }

    private Collection<MutableReasonDetail> collectAllowedReasons(Collection<MutableReasonDetail> reasons) {
        ArrayList<MutableReasonDetail> allowedReasons = new ArrayList<MutableReasonDetail>();
        for (MutableReasonDetail reasonDetail : reasons) {
            for (Matcher<MutableReasonDetail> allowedReasonMatcher : this.allowedReasonMatchers) {
                if (!allowedReasonMatcher.matches((Object)reasonDetail)) continue;
                allowedReasons.add(reasonDetail);
            }
        }
        return allowedReasons;
    }

    private void describeMismatchedReasons(Description mismatchDescription, Collection<MutableReasonDetail> unmatchedReasons, Collection<MutableReasonDetail> allowedReasons) {
        mismatchDescription.appendText(String.format("    Reasons:%n", new Object[0]));
        mismatchDescription.appendText(ReasonsFormatter.formatReasons(unmatchedReasons));
        mismatchDescription.appendText(String.format("    Allowed reasons:%n", new Object[0]));
        mismatchDescription.appendText(allowedReasons.isEmpty() ? "        None." : ReasonsFormatter.formatReasons(allowedReasons));
    }

    public void describeTo(Description description) {
        this.isImmutable.describeTo(description);
    }
}

