/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.unittesting.matchers.reasons;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.MutableReasonDetail;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableSet;
import org.mutabilitydetector.locations.CodeLocation;
import org.mutabilitydetector.unittesting.matchers.reasons.BaseMutableReasonDetailMatcher;

public final class FieldAssumptions {
    private final Set<String> fieldNames;

    private FieldAssumptions(Set<String> fieldNames) {
        this.fieldNames = Collections.unmodifiableSet(new HashSet<String>(fieldNames));
    }

    public static FieldAssumptions named(Set<String> fieldNames) {
        return new FieldAssumptions(ImmutableSet.copyOf(fieldNames));
    }

    public Matcher<MutableReasonDetail> areSafelyCopiedUnmodifiableCollectionsWithImmutableElements() {
        return new AssumeCopiedIntoUnmodifiable();
    }

    public Matcher<MutableReasonDetail> areNotModifiedAndDoNotEscape() {
        return new MutableFieldNotModifiedAndDoesntEscapeMatcher();
    }

    public Matcher<MutableReasonDetail> areModifiedAsPartOfAnUnobservableCachingStrategy() {
        return new FieldModifiedAsPartOfAnUnobservableCachingStrategy();
    }

    private class FieldLocationWithNameMatcher
    extends TypeSafeMatcher<CodeLocation.FieldLocation> {
        private FieldLocationWithNameMatcher() {
        }

        public void describeTo(Description description) {
        }

        protected boolean matchesSafely(CodeLocation.FieldLocation locationOfMutability) {
            return FieldAssumptions.this.fieldNames.contains(locationOfMutability.fieldName());
        }
    }

    private final class FieldModifiedAsPartOfAnUnobservableCachingStrategy
    extends BaseMutableReasonDetailMatcher {
        private FieldModifiedAsPartOfAnUnobservableCachingStrategy() {
        }

        protected boolean matchesSafely(MutableReasonDetail reasonDetail) {
            return new FieldLocationWithNameMatcher().matches(reasonDetail.codeLocation()) && reasonDetail.reason().isOneOf(MutabilityReason.MUTABLE_TYPE_TO_FIELD, MutabilityReason.COLLECTION_FIELD_WITH_MUTABLE_ELEMENT_TYPE, MutabilityReason.ARRAY_TYPE_INHERENTLY_MUTABLE, MutabilityReason.FIELD_CAN_BE_REASSIGNED, MutabilityReason.NON_FINAL_FIELD);
        }
    }

    private final class MutableFieldNotModifiedAndDoesntEscapeMatcher
    extends BaseMutableReasonDetailMatcher {
        private MutableFieldNotModifiedAndDoesntEscapeMatcher() {
        }

        protected boolean matchesSafely(MutableReasonDetail reasonDetail) {
            return new FieldLocationWithNameMatcher().matches(reasonDetail.codeLocation()) && reasonDetail.reason().isOneOf(MutabilityReason.MUTABLE_TYPE_TO_FIELD, MutabilityReason.COLLECTION_FIELD_WITH_MUTABLE_ELEMENT_TYPE, MutabilityReason.ARRAY_TYPE_INHERENTLY_MUTABLE);
        }
    }

    private final class AssumeCopiedIntoUnmodifiable
    extends BaseMutableReasonDetailMatcher {
        private AssumeCopiedIntoUnmodifiable() {
        }

        protected boolean matchesSafely(MutableReasonDetail reasonDetail) {
            return new FieldLocationWithNameMatcher().matches(reasonDetail.codeLocation()) && reasonDetail.reason().isOneOf(MutabilityReason.ABSTRACT_COLLECTION_TYPE_TO_FIELD, MutabilityReason.ABSTRACT_TYPE_TO_FIELD, MutabilityReason.COLLECTION_FIELD_WITH_MUTABLE_ELEMENT_TYPE);
        }
    }
}

