/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.misc;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.mutabilitydetector.internal.com.google.common.base.Joiner;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableCollection;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableList;
import org.mutabilitydetector.internal.org.objectweb.asm.signature.SignatureVisitor;

public final class TracingSignatureVisitor
extends SignatureVisitor {
    private List<Integer> treePath;
    private int nextBranch = 1;
    private PrintWriter log;

    private TracingSignatureVisitor(List<Integer> treePath, PrintWriter log) {
        super(327680);
        this.treePath = treePath;
        this.log = new PrintWriter((Writer)log, true);
    }

    public TracingSignatureVisitor(PrintWriter log) {
        this(ImmutableList.of(Integer.valueOf(1)), log);
    }

    @Override
    public void visitFormalTypeParameter(String name) {
        this.trace(String.format("visitFormalTypeParameter(%s)", name), new Object[0]);
    }

    @Override
    public SignatureVisitor visitClassBound() {
        this.trace("visitClassBound()", new Object[0]);
        return this.nextVisitor();
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        this.trace("visitInterfaceBound()", new Object[0]);
        return this.nextVisitor();
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        this.trace("visitSuperclass()", new Object[0]);
        return this.nextVisitor();
    }

    @Override
    public SignatureVisitor visitInterface() {
        this.trace("visitInterface()", new Object[0]);
        return this.nextVisitor();
    }

    @Override
    public SignatureVisitor visitParameterType() {
        this.trace("visitParameterType()", new Object[0]);
        return this.nextVisitor();
    }

    @Override
    public SignatureVisitor visitReturnType() {
        this.trace("visitReturnType()", new Object[0]);
        return this.nextVisitor();
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        this.trace("visitExceptionType()", new Object[0]);
        return this.nextVisitor();
    }

    @Override
    public void visitBaseType(char descriptor) {
        this.trace("visitBaseType(%s)", "" + descriptor);
    }

    @Override
    public void visitTypeVariable(String name) {
        this.trace("visitTypeVariable(%s)", name);
    }

    @Override
    public SignatureVisitor visitArrayType() {
        this.trace("visitArrayType()", new Object[0]);
        return this.nextVisitor();
    }

    @Override
    public void visitClassType(String name) {
        this.trace("visitClassType(%s)", name);
    }

    @Override
    public void visitInnerClassType(String name) {
        this.trace("visitInnerClassType(%s)", name);
    }

    @Override
    public void visitTypeArgument() {
        this.trace("visitTypeArgument()", new Object[0]);
    }

    @Override
    public SignatureVisitor visitTypeArgument(char wildcard) {
        this.trace("visitTypeArgument(%s)", "" + wildcard);
        return this.nextVisitor();
    }

    @Override
    public void visitEnd() {
        this.trace("visitEnd()", new Object[0]);
    }

    private SignatureVisitor nextVisitor() {
        ImmutableCollection newPath = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.treePath)).add((Object)this.nextBranch++)).build();
        return new TracingSignatureVisitor((List<Integer>)((Object)newPath), this.log);
    }

    private void trace(String formatString, Object ... args) {
        this.log.println(this.toString() + " " + String.format(formatString, args));
    }

    public String toString() {
        return Joiner.on("-").join(this.treePath);
    }
}

