/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.locations;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.locations.ClassIdentifier;
import org.mutabilitydetector.locations.ClassNameConverter;
import org.mutabilitydetector.locations.Dotted;
import org.mutabilitydetector.locations.Slashed;

public abstract class CodeLocation<T extends CodeLocation<T>>
implements Comparable<T> {
    private CodeLocation() {
    }

    public abstract String typeName();

    public abstract String prettyPrint();

    @Immutable
    public static final class FieldLocation
    extends CodeLocation<FieldLocation> {
        @Nonnull
        private final String fieldName;
        @Nonnull
        private final ClassLocation ownerOfField;

        private FieldLocation(String fieldName, ClassLocation ownerOfField) {
            this.fieldName = fieldName;
            this.ownerOfField = ownerOfField;
        }

        public static FieldLocation fieldLocation(String fieldName, ClassLocation ownerOfField) {
            return new FieldLocation(fieldName, ownerOfField);
        }

        public String fieldName() {
            return this.fieldName;
        }

        @Override
        public String typeName() {
            return this.ownerOfField.typeName();
        }

        @Override
        public int compareTo(@Nonnull FieldLocation other) {
            int comparingOwner = this.ownerOfField.compareTo(other.ownerOfField);
            int comparingFieldName = this.fieldName.compareTo(other.fieldName);
            return comparingOwner == 0 ? comparingFieldName : comparingOwner;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fieldName.hashCode();
            result = 31 * result + this.ownerOfField.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldLocation other = (FieldLocation)obj;
            return this.fieldName.equals(other.fieldName) && this.ownerOfField.equals(other.ownerOfField);
        }

        @Override
        public String prettyPrint() {
            return String.format("[Field: %s, Class: %s]", this.fieldName(), this.typeName());
        }
    }

    @Immutable
    public static final class ClassLocation
    extends CodeLocation<ClassLocation> {
        @Nonnull
        private final String dottedClassName;

        public ClassLocation(String dottedClassName) {
            this.dottedClassName = dottedClassName;
        }

        @Override
        public String typeName() {
            return this.dottedClassName;
        }

        @Override
        public int compareTo(@Nonnull ClassLocation other) {
            return this.typeName().compareTo(other.typeName());
        }

        public int hashCode() {
            return this.dottedClassName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassLocation other = (ClassLocation)obj;
            return this.dottedClassName.equals(other.dottedClassName);
        }

        public static ClassLocation fromInternalName(String internalClassName) {
            String dottedClassName = new ClassNameConverter().dotted(internalClassName);
            return new ClassLocation(dottedClassName);
        }

        public static ClassLocation from(Slashed slashed) {
            String dottedClassName = ClassIdentifier.forClass(slashed).asDotted().asString();
            return new ClassLocation(dottedClassName);
        }

        public static ClassLocation from(Dotted dotted) {
            return new ClassLocation(dotted.asString());
        }

        @Override
        public String prettyPrint() {
            return String.format("[Class: %s]", this.typeName());
        }
    }

    @Immutable
    public static final class UnknownCodeLocation
    extends CodeLocation<UnknownCodeLocation> {
        public static final UnknownCodeLocation UNKNOWN = new UnknownCodeLocation();

        private UnknownCodeLocation() {
        }

        @Override
        public int compareTo(@Nonnull UnknownCodeLocation o) {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public String typeName() {
            return "unknown code location";
        }

        @Override
        public String prettyPrint() {
            return "[Unknown code location]";
        }
    }
}

