/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.locations;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.internal.com.google.common.base.Function;
import org.mutabilitydetector.internal.com.google.common.collect.FluentIterable;

@Immutable
public final class ClassNameConverter {
    public static final ClassNameConverter CONVERTER = new ClassNameConverter();
    public static final Function<String, String> TO_DOTTED_STRING = new Function<String, String>(){

        @Override
        public String apply(@Nonnull String input) {
            return CONVERTER.dotted(input);
        }
    };
    private static final Function<String, String> SINGLE_DIMENSIONAL_IF_ARRAY = new Function<String, String>(){

        @Override
        public String apply(@Nonnull String input) {
            return input.replaceAll("\\[+", "[");
        }
    };
    private static final Function<String, String> REMOVE_ARRAY_DESCRIPTOR_IF_REFERENCE_TYPE = new Function<String, String>(){

        @Override
        public String apply(@Nonnull String input) {
            return input.startsWith("[L") ? input.replace("[L", "") : input;
        }
    };
    private static final Function<String, String> REMOVE_REFERENCE_DESCRIPTOR_IF_REFERENCE_TYPE = new Function<String, String>(){

        @Override
        public String apply(@Nonnull String input) {
            return input.startsWith("L") ? input.substring(1) : input;
        }
    };
    private static final Function<String, String> REMOVE_CLASS_EXTENSION = new Function<String, String>(){

        @Override
        public String apply(@Nonnull String input) {
            return input.endsWith(".class") ? input.replace(".class", "") : input;
        }
    };
    private static final Function<String, String> REMOVE_TRAILING_SEMICOLON = new Function<String, String>(){

        @Override
        public String apply(@Nonnull String input) {
            return input.replace(";", "");
        }
    };
    private static final Function<String, String> REPLACE_SLASHES_WITH_DOTS = new Function<String, String>(){

        @Override
        public String apply(@Nonnull String input) {
            return input.replace("/", ".");
        }
    };

    public String dotted(String givenClassName) {
        return FluentIterable.from(Collections.singleton(givenClassName)).transform(SINGLE_DIMENSIONAL_IF_ARRAY).transform(REMOVE_ARRAY_DESCRIPTOR_IF_REFERENCE_TYPE).transform(REMOVE_REFERENCE_DESCRIPTOR_IF_REFERENCE_TYPE).transform(REMOVE_CLASS_EXTENSION).transform(REMOVE_TRAILING_SEMICOLON).transform(REPLACE_SLASHES_WITH_DOTS).first().get();
    }
}

