/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.internal.com.google.classpath;

import java.io.InputStream;
import java.util.Arrays;
import java.util.TreeSet;
import org.mutabilitydetector.internal.com.google.classpath.ClassPath;
import org.mutabilitydetector.internal.com.google.classpath.ResourceFilter;

public class CompositeClassPath
implements ClassPath {
    private final ClassPath[] classPaths;

    public CompositeClassPath(ClassPath ... classPaths) {
        this.classPaths = classPaths;
    }

    public boolean isResource(String resource) {
        for (ClassPath classPath : this.classPaths) {
            if (!classPath.isResource(resource)) continue;
            return true;
        }
        return false;
    }

    public boolean isPackage(String packageName) {
        for (ClassPath classPath : this.classPaths) {
            if (!classPath.isPackage(packageName)) continue;
            return true;
        }
        return false;
    }

    public String[] listPackages(String packageName) {
        TreeSet<String> packages = new TreeSet<String>();
        for (ClassPath classPath : this.classPaths) {
            packages.addAll(Arrays.asList(classPath.listPackages(packageName)));
        }
        return packages.toArray(new String[packages.size()]);
    }

    public String[] listResources(String packageName) {
        TreeSet<String> resources = new TreeSet<String>();
        for (ClassPath classPath : this.classPaths) {
            resources.addAll(Arrays.asList(classPath.listResources(packageName)));
        }
        return resources.toArray(new String[resources.size()]);
    }

    public InputStream getResourceAsStream(String resource) {
        for (ClassPath classPath : this.classPaths) {
            InputStream is = classPath.getResourceAsStream(resource);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public String[] findResources(String rootPackageName, ResourceFilter resourceFilter) {
        TreeSet<String> resources = new TreeSet<String>();
        for (ClassPath classPath : this.classPaths) {
            resources.addAll(Arrays.asList(classPath.findResources(rootPackageName, resourceFilter)));
        }
        return resources.toArray(new String[resources.size()]);
    }
}

