/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.internal.com.google.classpath;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.mutabilitydetector.internal.com.google.classpath.ClassPath;
import org.mutabilitydetector.internal.com.google.classpath.CompositeClassPath;
import org.mutabilitydetector.internal.com.google.classpath.DirectoryClassPath;
import org.mutabilitydetector.internal.com.google.classpath.JARClassPath;

public class ClassPathFactory {
    public static final String JAVA_CLASS_PATH = "java.class.path";

    public String getJVMClasspath() {
        return System.getProperty(JAVA_CLASS_PATH);
    }

    public String[] parseClasspath(String classpath) {
        return classpath.split(File.pathSeparator);
    }

    public ClassPath createFromJVM() {
        return this.createFromPath(this.getJVMClasspath());
    }

    public ClassPath createFromPath(String classpath) {
        return this.createFromPaths(this.parseClasspath(classpath));
    }

    public ClassPath createFromPaths(String ... paths) {
        ArrayList<ClassPath> classPaths = new ArrayList<ClassPath>();
        for (String path : paths) {
            File file = new File(path);
            if (file.isFile()) {
                try {
                    classPaths.add(new JARClassPath(file).loadEntries());
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!file.isDirectory()) continue;
            classPaths.add(new DirectoryClassPath(file));
        }
        ClassPath[] array = new ClassPath[classPaths.size()];
        array = classPaths.toArray(array);
        return new CompositeClassPath(array);
    }
}

