/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.util;

import org.mutabilitydetector.checkers.AccessModifierQuery;
import org.mutabilitydetector.checkers.MutabilityAnalysisException;
import org.mutabilitydetector.checkers.info.TypeInformationRetriever;
import org.mutabilitydetector.locations.Dotted;

public class TypeStructureInformationAnalyser
extends TypeInformationRetriever {
    private final Dotted className;
    private Boolean isAbstract;
    private boolean isInterface;

    private TypeStructureInformationAnalyser(Dotted className) {
        this.className = className;
    }

    public static TypeStructureInformationAnalyser newAnalyser(Dotted className) {
        return new TypeStructureInformationAnalyser(className);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.checkIsVisitingCorrectClass();
        this.storeIsAbstract(access);
        this.storeIsInterface(access);
    }

    private void checkIsVisitingCorrectClass() {
        Dotted expectToVisit = Dotted.fromSlashedString(this.ownerClass);
        if (!expectToVisit.equals(this.className)) {
            String message = String.format("Programming error: Expected to visit [%s], but am visiting [%s].", this.className, expectToVisit);
            throw new MutabilityAnalysisException(message);
        }
    }

    private void storeIsAbstract(int access) {
        this.isAbstract = AccessModifierQuery.type(access).isAbstract();
    }

    private void storeIsInterface(int access) {
        this.isInterface = AccessModifierQuery.type(access).isInterface();
    }
}

