/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.info;

import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.AnalysisResult;
import org.mutabilitydetector.AnalysisSession;
import org.mutabilitydetector.Configuration;
import org.mutabilitydetector.checkers.info.AnalysisInProgress;
import org.mutabilitydetector.checkers.info.CopyMethod;
import org.mutabilitydetector.checkers.info.CyclicReferences;
import org.mutabilitydetector.internal.com.google.common.base.Optional;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableMultimap;
import org.mutabilitydetector.locations.Dotted;

public final class MutableTypeInformation {
    private final AnalysisSession analysisSession;
    private final Configuration configuration;
    private final CyclicReferences cyclicReferences;

    public MutableTypeInformation(AnalysisSession analysisSession, Configuration configuration, CyclicReferences cyclicReferences) {
        this.analysisSession = analysisSession;
        this.configuration = configuration;
        this.cyclicReferences = cyclicReferences;
    }

    public ImmutableMultimap<String, CopyMethod> hardcodedCopyMethods() {
        return this.configuration.hardcodedCopyMethods();
    }

    public MutabilityLookup resultOf(Dotted ownerClass, Dotted fieldClass, AnalysisInProgress analysisInProgress) {
        Optional<AnalysisResult> alreadyComputedResult = this.existingResult(fieldClass);
        return alreadyComputedResult.isPresent() ? MutabilityLookup.complete(alreadyComputedResult.get()) : this.requestAnalysisIfNoCyclicReferenceDetected(ownerClass, fieldClass, analysisInProgress);
    }

    private MutabilityLookup requestAnalysisIfNoCyclicReferenceDetected(Dotted ownerClass, Dotted fieldClass, AnalysisInProgress analysisInProgress) {
        Optional<CyclicReferences.CyclicReference> cyclicReference = this.cyclicReferences.detectedBetween(ownerClass, fieldClass, analysisInProgress);
        if (cyclicReference.isPresent()) {
            return MutabilityLookup.foundCyclicReference(cyclicReference.get());
        }
        AnalysisResult result = this.analysisSession.processTransitiveAnalysis(fieldClass, analysisInProgress.analysisStartedFor(ownerClass));
        return MutabilityLookup.complete(result);
    }

    private Optional<AnalysisResult> existingResult(Dotted fieldClass) {
        AnalysisResult hardcodedResult = this.configuration.hardcodedResults().get(fieldClass);
        if (hardcodedResult != null) {
            return Optional.of(hardcodedResult);
        }
        return Optional.fromNullable(this.analysisSession.resultsByClass().get(fieldClass));
    }

    @Immutable
    public static final class MutabilityLookup {
        public final AnalysisResult result;
        public final boolean foundCyclicReference;
        public final CyclicReferences.CyclicReference cyclicReference;

        private MutabilityLookup(AnalysisResult result, CyclicReferences.CyclicReference cyclicReference) {
            this.result = result;
            this.foundCyclicReference = result == null;
            this.cyclicReference = cyclicReference;
        }

        public static MutabilityLookup foundCyclicReference(CyclicReferences.CyclicReference cyclicReference) {
            return new MutabilityLookup(null, Preconditions.checkNotNull(cyclicReference));
        }

        public static MutabilityLookup complete(AnalysisResult result) {
            return new MutabilityLookup(Preconditions.checkNotNull(result), null);
        }
    }
}

