/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.info;

import javax.annotation.concurrent.Immutable;
import org.mutabilitydetector.internal.com.google.common.base.Objects;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodInsnNode;
import org.mutabilitydetector.locations.Dotted;

@Immutable
public final class CopyMethod {
    public final Dotted owner;
    public final String name;
    public final String desc;
    public final boolean isGeneric;

    public CopyMethod(Dotted owner, String name, String desc) {
        this(owner, name, desc, false);
    }

    public CopyMethod(Dotted owner, String name, String desc, boolean isGeneric) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
        this.isGeneric = isGeneric;
    }

    public static CopyMethod from(MethodInsnNode methodNode) {
        return new CopyMethod(Dotted.dotted(methodNode.owner), methodNode.name, methodNode.desc);
    }

    public int hashCode() {
        return Objects.hashCode(this.desc, this.name, this.owner);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CopyMethod other = (CopyMethod)obj;
        return this.desc.equals(other.desc) && this.name.equals(other.name) && this.owner.equals(other.owner);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("owner", this.owner).add("name", this.name).add("desc", this.desc).toString();
    }
}

