/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.checkers.AccessModifierQuery;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.internal.org.objectweb.asm.FieldVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.locations.CodeLocation;

public class ArrayFieldMutabilityChecker
extends AsmMutabilityChecker {
    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (AccessModifierQuery.field(access).isNotStatic() && this.isArray(desc) && !this.isTheInternalImmutableArrayFieldInAnEnum(name)) {
            this.setResult("Field is an array.", CodeLocation.FieldLocation.fieldLocation(name, CodeLocation.ClassLocation.fromInternalName(this.ownerClass)), MutabilityReason.ARRAY_TYPE_INHERENTLY_MUTABLE);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    private boolean isTheInternalImmutableArrayFieldInAnEnum(String name) {
        return "ENUM$VALUES".equals(name);
    }

    private boolean isArray(String desc) {
        return 9 == Type.getType(desc).getSort();
    }
}

