/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.transport.tcp.SimpleServerSocketFactory;
import org.mule.transport.tcp.TcpPropertyHelper;
import org.mule.transport.tcp.i18n.TcpMessages;
import org.mule.util.NetworkUtils;
import org.mule.util.StringUtils;

public class TcpServerSocketFactory
implements SimpleServerSocketFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public ServerSocket createServerSocket(URI uri, int backlog, Boolean reuse) throws IOException {
        String host = StringUtils.defaultIfEmpty((String)uri.getHost(), (String)"localhost");
        InetAddress inetAddress = InetAddress.getByName(host);
        if ((inetAddress.equals(NetworkUtils.getLocalHost()) || host.trim().equals("localhost")) && TcpPropertyHelper.isBindingLocalhostToAllLocalInterfaces()) {
            this.logger.warn((Object)TcpMessages.localhostBoundToAllLocalInterfaces());
            return this.createServerSocket(uri.getPort(), backlog, reuse);
        }
        return this.createServerSocket(inetAddress, uri.getPort(), backlog, reuse);
    }

    @Override
    public ServerSocket createServerSocket(InetAddress address, int port, int backlog, Boolean reuse) throws IOException {
        return this.configure(new ServerSocket(), reuse, new InetSocketAddress(address, port), backlog);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, Boolean reuse) throws IOException {
        return this.configure(new ServerSocket(), reuse, new InetSocketAddress(port), backlog);
    }

    protected ServerSocket configure(ServerSocket socket, Boolean reuse, InetSocketAddress address, int backlog) throws IOException {
        if (null != reuse && reuse.booleanValue() != socket.getReuseAddress()) {
            socket.setReuseAddress(reuse);
        }
        socket.bind(address, backlog);
        return socket;
    }
}

