/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.retry.RetryContext;
import org.mule.api.transformer.TransformerException;
import org.mule.transport.NullPayload;
import org.mule.transport.tcp.AbstractTcpSocketFactory;
import org.mule.transport.tcp.TcpConnector;
import org.mule.transport.tcp.TcpMessageDispatcher;
import org.mule.transport.tcp.TcpSocketKey;

public class LocalSocketTcpMessageDispatcher
extends TcpMessageDispatcher {
    private AbstractTcpSocketFactory socketFactory = this.getConnector().getSocketFactory();
    private Socket socket;

    public LocalSocketTcpMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    public TcpConnector getConnector() {
        return (TcpConnector)super.getConnector();
    }

    @Override
    protected void doDispatch(MuleEvent event) throws Exception {
        this.dispatchToSocket(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized MuleMessage doSend(MuleEvent event) throws Exception {
        try {
            this.dispatchToSocket(event);
            if (this.returnResponse(event)) {
                Object result;
                block12: {
                    try {
                        result = LocalSocketTcpMessageDispatcher.receiveFromSocket(this.socket, event.getTimeout(), this.endpoint);
                        if (result != null) break block12;
                        DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage((Object)NullPayload.getInstance(), this.getEndpoint().getMuleContext());
                        return defaultMuleMessage;
                    }
                    catch (Exception ex) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info((Object)("Error occurred while Reading; Message: " + ex.getMessage()), (Throwable)ex);
                        }
                        this.closeSocket();
                        throw ex;
                    }
                }
                if (result instanceof MuleMessage) {
                    MuleMessage muleMessage = (MuleMessage)result;
                    return muleMessage;
                }
                DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage(result, this.getEndpoint().getMuleContext());
                return defaultMuleMessage;
            }
            MuleMessage muleMessage = event.getMessage();
            return muleMessage;
        }
        finally {
            if (!this.getConnector().isKeepSendSocketOpen()) {
                this.closeSocket();
            }
        }
    }

    private void closeSocket() {
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Exception ex) {
            this.logger.info((Object)("Error occurred while closing socket; Message: " + ex.getMessage()));
        }
    }

    protected void dispatchToSocket(MuleEvent event) throws Exception {
        if (this.socket == null || this.socket.isClosed()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Socket is null; Creating... ");
            }
            TcpSocketKey socketKey = new TcpSocketKey(this.endpoint);
            this.socket = (Socket)this.socketFactory.makeObject(socketKey);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Is socket closed? " + (this.socket != null && this.socket.isClosed())));
        }
        try {
            Object payload = event.getMessage().getPayload();
            event.getMessage().setPayload(payload);
            this.write(payload);
            return;
        }
        catch (IOException ioEx) {
            this.closeSocket();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Error occurred while Writing; Message: " + ioEx.getMessage()), (Throwable)ioEx);
            }
            if (ioEx instanceof SocketTimeoutException) {
                throw ioEx;
            }
        }
        catch (Exception ex) {
            this.logger.info((Object)("Unknown Error occurred while Writing; Message: " + ex.getMessage()), (Throwable)ex);
        }
    }

    private void write(Object data) throws IOException, TransformerException {
        BufferedOutputStream bos = new BufferedOutputStream(this.socket.getOutputStream());
        this.getConnector().getTcpProtocol().write(bos, data);
        bos.flush();
    }

    @Override
    public RetryContext validateConnection(RetryContext retryContext) {
        try {
            retryContext.setOk();
        }
        catch (Exception ex) {
            retryContext.setFailed((Throwable)ex);
        }
        return retryContext;
    }
}

