/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import javax.resource.spi.work.Work;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.NullPayload;
import org.mule.transport.tcp.TcpMessageReceiver;

public class ExceptionReturnTcpMessageReceiver
extends TcpMessageReceiver {
    public ExceptionReturnTcpMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    @Override
    protected Work createWork(Socket socket) throws IOException {
        return new TcpWorker(socket, (AbstractMessageReceiver)this);
    }

    protected class TcpWorker
    extends TcpMessageReceiver.TcpWorker {
        public TcpWorker(Socket socket, AbstractMessageReceiver receiver) throws IOException {
            super(ExceptionReturnTcpMessageReceiver.this, socket, receiver);
        }

        @Override
        protected Object getNextMessage(Object resource) throws Exception {
            try {
                return super.getNextMessage(resource);
            }
            catch (Exception e) {
                this.manageException(e);
                return null;
            }
        }

        private void manageException(Exception readingException) throws Exception {
            try {
                ExceptionReturnTcpMessageReceiver.this.logger.warn((Object)("Failed to read message: " + readingException));
                DefaultMuleMessage msg = new DefaultMuleMessage((Object)NullPayload.getInstance(), ExceptionReturnTcpMessageReceiver.this.getEndpoint().getMuleContext());
                DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload((Throwable)readingException);
                msg.setExceptionPayload((ExceptionPayload)exceptionPayload);
                ArrayList<DefaultMuleMessage> msgList = new ArrayList<DefaultMuleMessage>(1);
                msgList.add(msg);
                this.handleResults(msgList);
            }
            catch (Exception writingException) {
                ExceptionReturnTcpMessageReceiver.this.logger.warn((Object)("Failed to write exception back to client: " + writingException));
                throw writingException;
            }
        }
    }
}

