/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling;

import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.SchedulerFactory;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.NullPayload;
import org.mule.transport.polling.MessageProcessorPollingInterceptor;
import org.mule.transport.polling.MessageProcessorPollingOverride;

public class MessageProcessorPollingMessageReceiver
extends AbstractPollingMessageReceiver {
    public static final String SOURCE_MESSAGE_PROCESSOR_PROPERTY_NAME = "MULE_ENDPOINT__sourceMessageProcessor";
    public static final String POLL_OVERRIDE_PROPERTY_NAME = "MULE_ENDPOINT__pollOverride";
    public static final String SCHEDULER_FACTORY_PROPERTY_NAME = "MULE_ENDPOINT__schedulerFactory";
    public static final String POLLING_TRANSPORT = "polling";
    private static final String POLLING_SCHEDULER_NAME_FORMAT = "polling://%s/%s";
    private Scheduler scheduler;
    protected MessageProcessor sourceMessageProcessor;
    protected MessageProcessorPollingOverride override;

    private static String schedulerNameOf(MessageProcessorPollingMessageReceiver source) {
        return String.format(POLLING_SCHEDULER_NAME_FORMAT, source.flowConstruct.getName(), source.hashCode());
    }

    public MessageProcessorPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    @Override
    public void poll() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"", (Map<String, Object>)null, this.getEndpoint().getMuleContext());
        this.pollWith(request);
    }

    public void pollWith(final MuleMessage request) throws Exception {
        ExecutionTemplate<MuleEvent> executionTemplate = this.createExecutionTemplate();
        try {
            final MessageProcessorPollingInterceptor interceptor = this.override.interceptor();
            MuleEvent muleEvent = executionTemplate.execute(new ExecutionCallback<MuleEvent>(){

                @Override
                public MuleEvent process() throws Exception {
                    ImmutableEndpoint ep = MessageProcessorPollingMessageReceiver.this.endpoint;
                    if (MessageProcessorPollingMessageReceiver.this.sourceMessageProcessor instanceof ImmutableEndpoint) {
                        ep = (ImmutableEndpoint)((Object)MessageProcessorPollingMessageReceiver.this.sourceMessageProcessor);
                    }
                    MuleEvent event = new DefaultMuleEvent(request, ep.getExchangePattern(), MessageProcessorPollingMessageReceiver.this.flowConstruct);
                    event = interceptor.prepareSourceEvent(event);
                    OptimizedRequestContext.criticalSetEvent(event);
                    MuleEvent sourceEvent = MessageProcessorPollingMessageReceiver.this.sourceMessageProcessor.process(event);
                    if (MessageProcessorPollingMessageReceiver.this.isNewMessage(sourceEvent)) {
                        event = interceptor.prepareRouting(sourceEvent, MessageProcessorPollingMessageReceiver.this.createMuleEvent(sourceEvent.getMessage(), null));
                        MessageProcessorPollingMessageReceiver.this.routeEvent(event);
                        interceptor.postProcessRouting(event);
                    } else {
                        MessageProcessorPollingMessageReceiver.this.logger.info((Object)CoreMessages.pollSourceReturnedNull(MessageProcessorPollingMessageReceiver.this.flowConstruct.getName()));
                    }
                    return null;
                }
            });
            if (muleEvent != null) {
                interceptor.postProcessRouting(muleEvent);
            }
        }
        catch (MessagingException interceptor) {
        }
        catch (Exception e) {
            this.getEndpoint().getMuleContext().getExceptionListener().handleException(e);
        }
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.sourceMessageProcessor = this.getSourceMessageProcessor();
        this.override = this.getPollOverride();
        if (this.override instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.override)).setMuleContext(this.endpoint.getMuleContext());
        }
        if (this.override instanceof Initialisable) {
            ((Initialisable)((Object)this.override)).initialise();
        }
        this.createScheduler();
    }

    @Override
    protected boolean pollOnPrimaryInstanceOnly() {
        return true;
    }

    @Override
    protected void doStart() throws MuleException {
        if (this.override instanceof Startable) {
            ((Startable)((Object)this.override)).start();
        }
    }

    @Override
    protected void doStop() throws MuleException {
        if (this.override instanceof Stoppable) {
            ((Stoppable)((Object)this.override)).stop();
        }
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDispose() {
        try {
            if (this.override instanceof Disposable) {
                try {
                    ((Disposable)((Object)this.override)).dispose();
                }
                catch (Exception e) {
                    this.logger.warn((Object)String.format("Could not dispose polling override of class %s. Message receiver will continue to dispose", this.override.getClass().getCanonicalName()), (Throwable)e);
                }
            }
            this.disposeScheduler();
        }
        finally {
            super.doDispose();
        }
    }

    private void createScheduler() {
        this.scheduler = this.getSchedulerFactory().create(MessageProcessorPollingMessageReceiver.schedulerNameOf(this), (Runnable)((Object)this.createWork()));
    }

    private void disposeScheduler() {
        if (this.scheduler != null) {
            try {
                this.flowConstruct.getMuleContext().getRegistry().unregisterScheduler(this.scheduler);
            }
            catch (MuleException e) {
                this.logger.warn((Object)String.format("Could not unregister scheduler %s from registry.", this.scheduler.getName()), (Throwable)e);
            }
            this.scheduler = null;
        }
    }

    protected boolean isNewMessage(MuleEvent sourceEvent) {
        if (sourceEvent != null && !VoidMuleEvent.getInstance().equals(sourceEvent) && sourceEvent.getMessage() != null) {
            MuleMessage message = sourceEvent.getMessage();
            return !message.getPayload().equals(NullPayload.getInstance());
        }
        return false;
    }

    private MessageProcessorPollingOverride getPollOverride() {
        MessageProcessorPollingOverride override = (MessageProcessorPollingOverride)this.endpoint.getProperty(POLL_OVERRIDE_PROPERTY_NAME);
        if (override == null) {
            override = new NoOverride();
        }
        return override;
    }

    private MessageProcessor getSourceMessageProcessor() throws InitialisationException {
        MessageProcessor messageSource = (MessageProcessor)this.endpoint.getProperty(SOURCE_MESSAGE_PROCESSOR_PROPERTY_NAME);
        this.validate(messageSource);
        return messageSource;
    }

    private void validate(MessageProcessor messageSource) throws InitialisationException {
        if (messageSource instanceof OutboundEndpoint && !((OutboundEndpoint)messageSource).getExchangePattern().hasResponse()) {
            throw new InitialisationException(CoreMessages.wrongMessageSource(messageSource.toString()), (Initialisable)this);
        }
    }

    private SchedulerFactory<Runnable> getSchedulerFactory() {
        return (SchedulerFactory)this.endpoint.getProperty(SCHEDULER_FACTORY_PROPERTY_NAME);
    }

    private static class NoOverride
    extends MessageProcessorPollingOverride {
        private MessageProcessorPollingInterceptor noOpInterceptor = new MessageProcessorPollingInterceptor(){};

        private NoOverride() {
        }

        @Override
        public MessageProcessorPollingInterceptor interceptor() {
            return this.noOpInterceptor;
        }
    }
}

