/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.types;

import java.lang.reflect.Method;
import java.util.Collection;
import org.mule.api.transformer.DataType;
import org.mule.transformer.types.ImmutableDataType;
import org.mule.transformer.types.SimpleDataType;
import org.mule.util.generics.GenericsUtils;
import org.mule.util.generics.MethodParameter;

public class CollectionDataType<T>
extends SimpleDataType<T> {
    private Class<? extends Collection> collectionType;

    public CollectionDataType(Class<? extends Collection> collectionType) {
        super(Object.class);
        this.collectionType = collectionType;
    }

    public CollectionDataType(Class<? extends Collection> collectionType, String mimeType) {
        super(Object.class, mimeType);
        this.collectionType = collectionType;
    }

    public CollectionDataType(Class<? extends Collection> collectionType, Class type, String mimeType) {
        super(type, mimeType);
        this.collectionType = collectionType;
    }

    public CollectionDataType(Class<? extends Collection> collectionType, Class type) {
        super(type);
        this.collectionType = collectionType;
    }

    public Class<?> getItemType() {
        return this.type;
    }

    @Override
    public Class getType() {
        return this.collectionType;
    }

    public static CollectionDataType createFromMethodReturn(Method m) {
        return CollectionDataType.createFromMethodReturn(m, null);
    }

    public static CollectionDataType createFromMethodReturn(Method m, String mimeType) {
        Class<?> collType = GenericsUtils.getCollectionReturnType(m);
        if (collType != null) {
            return new CollectionDataType(m.getReturnType(), collType, mimeType);
        }
        throw new IllegalArgumentException("Return type for method is not a generic type collection. " + m);
    }

    public static CollectionDataType createFromMethodParam(Method m, int paramIndex) {
        return CollectionDataType.createFromMethodParam(m, paramIndex, null);
    }

    public static CollectionDataType createFromMethodParam(Method m, int paramIndex, String mimeType) {
        Class<?> collType = GenericsUtils.getCollectionParameterType(new MethodParameter(m, paramIndex));
        if (collType != null) {
            return new CollectionDataType(m.getParameterTypes()[paramIndex], collType, mimeType);
        }
        throw new IllegalArgumentException("Parameter type (index: " + paramIndex + ") for method is not a generic type collection. " + m);
    }

    public static boolean isReturnTypeACollection(Method m) {
        return GenericsUtils.getCollectionReturnType(m) != null;
    }

    public static boolean isParamTypeACollection(Method m, int paramIndex) {
        return GenericsUtils.getCollectionParameterType(new MethodParameter(m, paramIndex)) != null;
    }

    @Override
    public boolean isCompatibleWith(DataType dataType) {
        if (dataType instanceof ImmutableDataType) {
            dataType = ((ImmutableDataType)dataType).getWrappedDataType();
        }
        if (!(dataType instanceof CollectionDataType)) {
            return false;
        }
        if (!super.isCompatibleWith(dataType)) {
            return false;
        }
        CollectionDataType that = (CollectionDataType)dataType;
        return that.getItemType() == Object.class || this.getItemType().isAssignableFrom(that.getItemType());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionDataType that = (CollectionDataType)o;
        if (!this.getItemType().equals(that.getItemType())) {
            return false;
        }
        if ((this.mimeType != null ? !this.mimeType.equals(that.mimeType) : that.mimeType != null) && !"*/*".equals(that.mimeType) && !"*/*".equals(this.mimeType)) {
            return false;
        }
        return this.getType().equals(that.getType());
    }

    @Override
    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.getItemType().hashCode();
        result = 31 * result + (this.getMimeType() != null ? this.getMimeType().hashCode() : 0);
        result = 31 * result + (this.getEncoding() != null ? this.getEncoding().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "CollectionDataType{type=" + this.getType().getName() + ", itemType=" + this.getItemType().getName() + ", mimeType='" + this.getMimeType() + '\'' + '}';
    }
}

