/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import javax.inject.Inject;
import org.mule.api.Injector;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.LifecycleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.registry.TransientRegistry;
import org.reflections.ReflectionUtils;

public class SimpleRegistry
extends TransientRegistry
implements LifecycleRegistry,
Injector {
    private static final String REGISTRY_ID = "org.mule.Registry.Simple";

    public SimpleRegistry(MuleContext muleContext) {
        super(REGISTRY_ID, muleContext);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.injectFieldDependencies();
        this.initialiseObjects();
        super.doInitialise();
    }

    @Override
    public <T> T lookupObject(String key, boolean applyLifecycle) {
        return this.lookupObject(key);
    }

    @Override
    protected void doRegisterObject(String key, Object object, Object metadata) throws RegistrationException {
        Object previous = this.doGet(key);
        if (previous != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("An entry already exists for key %s. It will be replaced", key));
            }
            this.unregisterObject(key);
        }
        this.doPut(key, object);
        try {
            this.getLifecycleManager().applyCompletedPhases(object);
        }
        catch (MuleException e) {
            throw new RegistrationException(e);
        }
    }

    @Override
    public Object applyLifecycle(Object object) throws MuleException {
        this.getLifecycleManager().applyCompletedPhases(object);
        return object;
    }

    @Override
    public Object applyLifecycle(Object object, String phase) throws MuleException {
        if (phase == null) {
            this.getLifecycleManager().applyCompletedPhases(object);
        } else {
            this.getLifecycleManager().applyPhase(object, "not in lifecycle", phase);
        }
        return object;
    }

    @Override
    public <T> T inject(T object) {
        return (T)this.applyProcessors(object, null);
    }

    @Override
    protected Object applyProcessors(Object object, Object metadata) {
        return this.injectInto(super.applyProcessors(object, metadata));
    }

    private void injectFieldDependencies() throws InitialisationException {
        for (Object object : this.lookupObjects(Object.class)) {
            this.injectInto(object);
        }
    }

    private <T> T injectInto(T object) {
        for (Field field : ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Inject.class)})) {
            Class<?> dependencyType = field.getType();
            try {
                Object dependency = this.lookupObject(dependencyType);
                if (dependency == null) continue;
                field.setAccessible(true);
                field.set(object, dependency);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not inject dependency on field %s of type %s", field.getName(), object.getClass().getName()), e);
            }
        }
        return object;
    }

    private void initialiseObjects() throws InitialisationException {
        try {
            for (Initialisable initialisable : this.lookupObjects(Initialisable.class)) {
                this.getLifecycleManager().applyPhase(initialisable, "not in lifecycle", "initialise");
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }
}

