/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.context.notification.ConnectorMessageNotification;
import org.mule.context.notification.OptimisedNotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHelper {
    private static final Logger logger = LoggerFactory.getLogger(NotificationHelper.class);
    private final Class<? extends ServerNotification> notificationClass;
    private final boolean dynamicNotifications;
    private final ServerNotificationHandler defaultNotificationHandler;
    private final LoadingCache<MuleContext, ServerNotificationHandler> serverNotificationHandlers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<MuleContext, ServerNotificationHandler>(){

        public ServerNotificationHandler load(MuleContext muleContext) throws Exception {
            return NotificationHelper.this.adaptNotificationHandler(muleContext.getNotificationManager());
        }
    });

    public NotificationHelper(ServerNotificationHandler defaultNotificationHandler, Class<? extends ServerNotification> notificationClass, boolean dynamicNotifications) {
        this.notificationClass = notificationClass;
        this.dynamicNotifications = dynamicNotifications;
        this.defaultNotificationHandler = this.adaptNotificationHandler(defaultNotificationHandler);
    }

    public boolean isNotificationEnabled() {
        return this.defaultNotificationHandler.isNotificationEnabled(this.notificationClass);
    }

    public boolean isNotificationEnabled(MuleEvent event) {
        return this.getNotificationHandler(event).isNotificationEnabled(this.notificationClass);
    }

    @Deprecated
    public void fireNotification(MuleMessage message, String uri, FlowConstruct flowConstruct, int action) {
        this.doFireNotification(this.defaultNotificationHandler, message, uri, flowConstruct, action);
    }

    public void fireNotification(MuleEvent event, String uri, FlowConstruct flowConstruct, int action) {
        this.doFireNotification(this.getNotificationHandler(event), event.getMessage(), uri, flowConstruct, action);
    }

    public void fireNotification(ServerNotification notification) {
        this.defaultNotificationHandler.fireNotification(notification);
    }

    public void fireNotification(ServerNotification notification, MuleEvent event) {
        this.getNotificationHandler(event).fireNotification(notification);
    }

    private void doFireNotification(ServerNotificationHandler serverNotificationHandler, MuleMessage message, String uri, FlowConstruct flowConstruct, int action) {
        try {
            if (serverNotificationHandler.isNotificationEnabled(this.notificationClass)) {
                serverNotificationHandler.fireNotification(new ConnectorMessageNotification(message, uri, flowConstruct, action));
            }
        }
        catch (Exception e) {
            logger.warn("Could not fire notification. Action: " + action, (Throwable)e);
        }
    }

    private ServerNotificationHandler adaptNotificationHandler(ServerNotificationHandler serverNotificationHandler) {
        return this.dynamicNotifications ? serverNotificationHandler : new OptimisedNotificationHandler(serverNotificationHandler, this.notificationClass);
    }

    private ServerNotificationHandler getNotificationHandler(MuleEvent event) {
        return (ServerNotificationHandler)this.serverNotificationHandlers.getUnchecked((Object)event.getMuleContext());
    }
}

