/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectStoreException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.store.PartitionedPersistentObjectStore;

public class PartitionedPersistentObjectStoreTestCase
extends AbstractMuleTestCase {
    public static final String OBJECT_KEY = "key";
    public static final String OBJECT_BASE_VALUE = "value";
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private PartitionedPersistentObjectStore<Serializable> os;
    private int numberOfPartitions = 3;

    @Before
    public void setUpMockMuleContext() throws IOException {
        this.numberOfPartitions = 3;
        Mockito.when((Object)this.mockMuleContext.getConfiguration().getWorkingDirectory()).thenReturn((Object)".");
        Mockito.when((Object)this.mockMuleContext.getExecutionClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        this.os = new PartitionedPersistentObjectStore(this.mockMuleContext);
        File objectStorePersistDir = new File("objectstore");
        if (objectStorePersistDir.exists()) {
            FileUtils.deleteDirectory((File)objectStorePersistDir);
        }
    }

    @Test
    public void defaultPartitionAndNamedPartitionsDoNotCollide() throws Exception {
        this.openPartitions();
        this.storeInPartitions(OBJECT_KEY, OBJECT_BASE_VALUE);
        this.assertAllValuesExistsInPartitionAreUnique(OBJECT_KEY, OBJECT_BASE_VALUE);
    }

    @Test
    public void removeEntries() throws Exception {
        this.openPartitions();
        this.storeInPartitions(OBJECT_KEY, OBJECT_BASE_VALUE);
        this.removeEntriesInPartitions();
        this.assertAllPartitionsAreEmpty();
    }

    @Test(expected=ObjectAlreadyExistsException.class)
    public void storeSameKeyThrowsException() throws Exception {
        this.numberOfPartitions = 0;
        this.openPartitions();
        this.storeInPartitions(OBJECT_KEY, OBJECT_BASE_VALUE);
        this.storeInPartitions(OBJECT_KEY, OBJECT_BASE_VALUE);
    }

    @Test
    public void objectStorePersistDataBetweenOpenAndClose() throws ObjectStoreException {
        this.openPartitions();
        this.storeInPartitions(OBJECT_KEY, OBJECT_BASE_VALUE);
        this.closePartitions();
        this.openPartitions();
        this.assertAllValuesExistsInPartitionAreUnique(OBJECT_KEY, OBJECT_BASE_VALUE);
    }

    private void closePartitions() throws ObjectStoreException {
        for (int i = 0; i < this.numberOfPartitions; ++i) {
            this.os.close(this.getPartitionName(i));
        }
        this.os.close();
    }

    private void assertAllPartitionsAreEmpty() throws ObjectStoreException {
        Assert.assertThat((Object)this.os.contains((Serializable)((Object)OBJECT_KEY)), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.os.allKeys().size(), (Matcher)Is.is((Object)0));
        for (int i = 0; i < this.numberOfPartitions; ++i) {
            Assert.assertThat((Object)this.os.contains((Serializable)((Object)OBJECT_KEY), this.getPartitionName(i)), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.os.allKeys(this.getPartitionName(i)).size(), (Matcher)Is.is((Object)0));
        }
    }

    private void removeEntriesInPartitions() throws ObjectStoreException {
        this.os.remove((Serializable)((Object)OBJECT_KEY));
        for (int i = 0; i < this.numberOfPartitions; ++i) {
            this.os.remove((Serializable)((Object)OBJECT_KEY), this.getPartitionName(i));
        }
    }

    private void assertAllValuesExistsInPartitionAreUnique(String key, String value) throws ObjectStoreException {
        Assert.assertThat((Object)((String)((Object)this.os.retrieve((Serializable)((Object)key)))), (Matcher)Is.is((Object)value));
        for (int i = 0; i < this.numberOfPartitions; ++i) {
            Assert.assertThat((Object)((String)((Object)this.os.retrieve((Serializable)((Object)key), this.getPartitionName(i)))), (Matcher)Is.is((Object)(value + i)));
        }
    }

    private void storeInPartitions(String key, String value) throws ObjectStoreException {
        this.os.store((Serializable)((Object)key), (Serializable)((Object)value));
        for (int i = 0; i < this.numberOfPartitions; ++i) {
            this.os.store((Serializable)((Object)key), (Serializable)((Object)(value + i)), this.getPartitionName(i));
        }
    }

    private void openPartitions() throws ObjectStoreException {
        this.os.open();
        for (int i = 0; i < this.numberOfPartitions; ++i) {
            this.os.open(this.getPartitionName(i));
        }
    }

    private String getPartitionName(int i) {
        return "partition" + i;
    }
}

