/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.QueueStore;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.concurrent.Latch;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueSession;
import org.mule.util.queue.TransactionalQueueManager;
import org.mule.util.store.QueueStoreAdapter;
import org.mule.util.store.SimpleMemoryObjectStore;

public abstract class AbstractTransactionQueueManagerTestCase
extends AbstractMuleContextTestCase {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    protected abstract TransactionalQueueManager createQueueManager() throws Exception;

    protected abstract boolean isPersistent();

    @Test
    public void testPutTake() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        q.put((Serializable)((Object)"String1"));
        Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
        Serializable o = q.take();
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        this.purgeQueue(q);
        mgr.stop(0);
    }

    @Test
    public void testTakePut() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        final Latch latch = new Latch();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    latch.countDown();
                    Thread.sleep(200L);
                    QueueSession s = mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                    q.put((Serializable)((Object)"String1"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        latch.await();
        long t0 = System.currentTimeMillis();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Serializable o = q.take();
        long t1 = System.currentTimeMillis();
        t.join();
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Assert.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        this.purgeQueue(q);
        mgr.stop(0);
    }

    @Test
    public void testPutTakeUntake() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        final Latch latch = new Latch();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    latch.countDown();
                    Thread.sleep(200L);
                    QueueSession s = mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                    q.put((Serializable)((Object)"String1"));
                    q.put((Serializable)((Object)"String2"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        latch.await();
        long t0 = System.currentTimeMillis();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Serializable o = q.take();
        long t1 = System.currentTimeMillis();
        t.join();
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
        Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
        Assert.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        q.untake(o);
        Assert.assertEquals((String)"Queue size", (long)2L, (long)q.size());
        Serializable o2 = q.take();
        Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o2);
        Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
        this.purgeQueue(q);
        mgr.stop(0);
    }

    @Test
    public void testTakePutRollbackPut() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        final Latch latch = new Latch();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    latch.countDown();
                    Thread.sleep(200L);
                    QueueSession s = mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                    s.begin();
                    q.put((Serializable)((Object)"String1"));
                    s.rollback();
                    s.begin();
                    q.put((Serializable)((Object)"String2"));
                    s.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        latch.await();
        long t0 = System.currentTimeMillis();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Serializable o = q.take();
        long t1 = System.currentTimeMillis();
        t.join();
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)"Queue content", (Object)"String2", (Object)o);
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Assert.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        this.purgeQueue(q);
        mgr.stop(0);
    }

    @Test
    public void testPutTakeUntakeRollbackUntake() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        final Latch latch = new Latch();
        String object1 = "string1";
        String object2 = "string2";
        Thread t = new Thread((Serializable)((Object)object1), (Serializable)((Object)object2)){
            final /* synthetic */ Serializable val$object1;
            final /* synthetic */ Serializable val$object2;
            {
                this.val$object1 = serializable;
                this.val$object2 = serializable2;
            }

            @Override
            public void run() {
                try {
                    latch.countDown();
                    Thread.sleep(200L);
                    QueueSession s = mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                    s.begin();
                    q.put(this.val$object1);
                    q.put(this.val$object2);
                    q.take();
                    q.take();
                    s.commit();
                    s.begin();
                    q.untake(this.val$object1);
                    s.commit();
                    s.begin();
                    q.untake(this.val$object2);
                    s.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        latch.await();
        long t0 = System.currentTimeMillis();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Serializable o = q.take();
        long t1 = System.currentTimeMillis();
        t.join();
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)"Queue content", (Object)object1, (Object)o);
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Assert.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        this.purgeQueue(q);
        mgr.stop(0);
    }

    @Test
    public void testTakePutOverCapacity() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        mgr.setDefaultQueueConfiguration(new QueueConfiguration(2, (QueueStore)new QueueStoreAdapter((ListableObjectStore)new SimpleMemoryObjectStore())));
        final Latch latch = new Latch();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    latch.await();
                    Thread.sleep(200L);
                    QueueSession s = mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Serializable o = q.take();
                    Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        q.put((Serializable)((Object)"String1"));
        q.put((Serializable)((Object)"String2"));
        latch.countDown();
        long t0 = System.currentTimeMillis();
        q.put((Serializable)((Object)"String3"));
        long t1 = System.currentTimeMillis();
        t.join();
        Assert.assertEquals((String)"Queue size", (long)2L, (long)q.size());
        Assert.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        this.purgeQueue(q);
        mgr.stop(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutWithPersistence() throws Exception {
        if (this.isPersistent()) {
            Queue q;
            QueueSession s;
            TransactionalQueueManager mgr = this.createQueueManager();
            try {
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                mgr.start();
                q.put((Serializable)((Object)"String1"));
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                q = s.getQueue("queue1");
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            }
            finally {
                mgr.stop(0);
            }
            mgr = this.createQueueManager();
            try {
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                mgr.start();
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                this.purgeQueue(q);
            }
            finally {
                mgr.stop(0);
            }
        }
        this.logger.info((Object)"Ignoring test because queue manager is not persistent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactedPutCommitWithPersistence() throws Exception {
        if (this.isPersistent()) {
            TransactionalQueueManager mgr = this.createQueueManager();
            try {
                QueueSession s = mgr.getQueueSession();
                Queue q = s.getQueue("queue1");
                mgr.start();
                s.begin();
                q.put((Serializable)((Object)"String1"));
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                s.commit();
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                mgr.stop(0);
                mgr = this.createQueueManager();
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                mgr.start();
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                this.purgeQueue(q);
            }
            finally {
                mgr.stop(0);
            }
        } else {
            this.logger.info((Object)"Ignoring test because queue manager is not persistent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactedPutRollbackWithPersistence() throws Exception {
        if (this.isPersistent()) {
            TransactionalQueueManager mgr = this.createQueueManager();
            try {
                mgr.start();
                QueueSession s = mgr.getQueueSession();
                Queue q = s.getQueue("queue1");
                s.begin();
                q.put((Serializable)((Object)"String1"));
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                s.rollback();
                Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                mgr.stop(0);
                mgr = this.createQueueManager();
                mgr.start();
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                this.purgeQueue(q);
            }
            finally {
                mgr.stop(0);
            }
        } else {
            this.logger.info((Object)"Ignoring test because queue manager is not persistent");
        }
    }

    @Test
    public void testPutTake_RespectsOrderOnPersistence() throws Exception {
        if (this.isPersistent()) {
            TransactionalQueueManager mgr1 = this.createQueueManager();
            QueueSession s1 = mgr1.getQueueSession();
            Queue q1 = s1.getQueue("queue1");
            mgr1.start();
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1.size());
            int numberOfElements = 10;
            for (int i = 1; i <= 10; ++i) {
                q1.put((Serializable)((Object)("String" + i)));
                Assert.assertEquals((String)"Queue size", (long)i, (long)q1.size());
            }
            mgr1.stop(0);
            TransactionalQueueManager mgr2 = this.createQueueManager();
            QueueSession s2 = mgr2.getQueueSession();
            Queue q2 = s2.getQueue("queue1");
            mgr2.start();
            for (int i = 1; i <= 10; ++i) {
                Serializable o = q2.take();
                Assert.assertNotNull((Object)o);
                Assert.assertEquals((String)"Queue content", (Object)("String" + i), (Object)o);
            }
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2.size());
            this.purgeQueue(q2);
            mgr2.stop(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionsOnMultipleQueues() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        try {
            mgr.start();
            QueueSession s1 = mgr.getQueueSession();
            QueueSession s2 = mgr.getQueueSession();
            Queue q1s1 = s1.getQueue("queue1");
            Queue q1s2 = s2.getQueue("queue1");
            Queue q2s1 = s1.getQueue("queue2");
            Queue q2s2 = s2.getQueue("queue2");
            q1s1.put((Serializable)((Object)"String1"));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q1s2.size());
            s1.begin();
            Serializable o = q1s1.take();
            Assert.assertNotNull((Object)o);
            Assert.assertEquals((Object)"String1", (Object)o);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s2.size());
            q2s1.put((Serializable)((Object)"String2"));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q2s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2s2.size());
            s1.commit();
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s2.size());
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q2s1.size());
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q2s2.size());
            s1.begin();
            o = q2s1.take();
            Assert.assertNotNull((Object)o);
            Assert.assertEquals((Object)"String2", (Object)o);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s2.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2s2.size());
            q1s1.put((Serializable)((Object)"String1"));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s2.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2s2.size());
            s1.rollback();
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s2.size());
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q2s1.size());
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q2s2.size());
            this.purgeQueue(q1s1);
            this.purgeQueue(q1s2);
            this.purgeQueue(q2s1);
            this.purgeQueue(q2s2);
        }
        finally {
            mgr.stop(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPoll() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        try {
            mgr.start();
            QueueSession s = mgr.getQueueSession();
            Queue q = s.getQueue("queue1");
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Serializable o = q.poll(0L);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Assert.assertNull((Object)o);
            o = q.poll(1000L);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Assert.assertNull((Object)o);
            q.put((Serializable)((Object)"String1"));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            o = q.poll(0L);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                        QueueSession s = mgr.getQueueSession();
                        Queue q = s.getQueue("queue1");
                        q.put((Serializable)((Object)"String1"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            o = q.poll(1000L);
            Assert.assertEquals((String)"Queue size", (long)q.size(), (long)0L);
            Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
            this.purgeQueue(q);
        }
        finally {
            mgr.stop(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeek() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        try {
            mgr.start();
            QueueSession s = mgr.getQueueSession();
            Queue q = s.getQueue("queue1");
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Serializable o = q.peek();
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Assert.assertNull((Object)o);
            q.put((Serializable)((Object)"String1"));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            o = q.peek();
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
            o = q.poll(1000L);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
            this.purgeQueue(q);
        }
        finally {
            mgr.stop(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOffer() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        mgr.setDefaultQueueConfiguration(new QueueConfiguration(1, (QueueStore)new QueueStoreAdapter((ListableObjectStore)new SimpleMemoryObjectStore())));
        try {
            mgr.start();
            QueueSession s = mgr.getQueueSession();
            Queue q = s.getQueue("queue1");
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Assert.assertTrue((boolean)q.offer((Serializable)((Object)"String1"), 0L));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            Assert.assertFalse((boolean)q.offer((Serializable)((Object)"String2"), 1000L));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                        QueueSession s = mgr.getQueueSession();
                        Queue q = s.getQueue("queue1");
                        Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)q.take());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            Assert.assertTrue((boolean)q.offer((Serializable)((Object)"String2"), 1000L));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            this.purgeQueue(q);
        }
        finally {
            mgr.stop(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBench() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        try {
            mgr.start();
            QueueSession s = mgr.getQueueSession();
            Queue q = s.getQueue("queue1");
            Random rnd = new Random();
            long t0 = System.currentTimeMillis();
            for (int i = 0; i < 1; ++i) {
                for (int j = 0; j < 500; ++j) {
                    byte[] o = new byte[2048];
                    rnd.nextBytes(o);
                    q.put((Serializable)o);
                }
                while (q.size() > 0) {
                    q.take();
                }
            }
            long t1 = System.currentTimeMillis();
            this.logger.info((Object)("Time: " + (t1 - t0) + " ms"));
            this.purgeQueue(q);
        }
        finally {
            mgr.stop(0);
        }
    }

    protected void purgeQueue(Queue queue) throws InterruptedException {
        while (queue.size() > 0) {
            queue.poll(1000L);
        }
        Assert.assertEquals((String)"Queue must be fully consumed after successful test run. Queue size:", (long)0L, (long)queue.size());
    }

    @Test
    public void testRecoverWarmRestart() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("warmRecoverQueue");
        int toPopulate = 500;
        Random rnd = new Random();
        for (int j = 0; j < toPopulate; ++j) {
            byte[] o = new byte[2048];
            rnd.nextBytes(o);
            q.put((Serializable)o);
        }
        Assert.assertEquals((long)q.size(), (long)toPopulate);
        mgr.stop();
        mgr.start();
        Assert.assertEquals((long)toPopulate, (long)q.size());
    }

    @Test
    public void testRecoverColdRestart() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("warmRecoverQueue");
        mgr.start();
        int toPopulate = 500;
        Random rnd = new Random();
        for (int j = 0; j < toPopulate; ++j) {
            byte[] o = new byte[2048];
            rnd.nextBytes(o);
            q.put((Serializable)o);
        }
        Assert.assertEquals((long)toPopulate, (long)q.size());
        mgr.stop();
        mgr = this.createQueueManager();
        s = mgr.getQueueSession();
        q = s.getQueue("warmRecoverQueue");
        mgr.start();
        if (this.isPersistent()) {
            Assert.assertEquals((long)toPopulate, (long)q.size());
        } else {
            Assert.assertEquals((long)0L, (long)q.size());
        }
    }
}

