/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;
import org.mule.transport.TransactedPollingMessageReceiver;

@RunWith(value=MockitoJUnitRunner.class)
public class TransactedPollingMessageReceiverTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private AbstractConnector mockConnector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FlowConstruct mockFlowConstruct;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private InboundEndpoint mockEndpoint;

    @Test
    public void callSystemExceptionHandlerReceivingMessage() throws Exception {
        Mockito.when((Object)this.mockEndpoint.getConnector()).thenReturn((Object)this.mockConnector);
        TestTransactedPollingMessageReceiver messageReceiver = new TestTransactedPollingMessageReceiver((Connector)this.mockConnector, this.mockFlowConstruct, this.mockEndpoint);
        messageReceiver.poll();
        ((MuleContext)Mockito.verify((Object)this.mockConnector.getMuleContext(), (VerificationMode)Mockito.timeout((int)1))).handleException((Exception)Matchers.any(Exception.class));
    }

    @Test
    public void callSystemExceptionHandlerReceivingMessageInTransaction() throws Exception {
        Mockito.when((Object)this.mockEndpoint.getConnector()).thenReturn((Object)this.mockConnector);
        TestTransactedPollingMessageReceiver messageReceiver = new TestTransactedPollingMessageReceiver((Connector)this.mockConnector, this.mockFlowConstruct, this.mockEndpoint);
        messageReceiver.setReceiveMessagesInTransaction(true);
        messageReceiver.poll();
        ((MuleContext)Mockito.verify((Object)this.mockConnector.getMuleContext(), (VerificationMode)Mockito.timeout((int)1))).handleException((Exception)Matchers.any(Exception.class));
    }

    public static class TestTransactedPollingMessageReceiver
    extends TransactedPollingMessageReceiver {
        public TestTransactedPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
            super(connector, flowConstruct, endpoint);
        }

        protected List<MuleMessage> getMessages() throws Exception {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"test exception"));
        }

        protected void processMessage(Object message) throws Exception {
        }
    }
}

