/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.transaction.Transaction;
import org.mule.transaction.TransactionCoordination;

public class TransactionTemplateTestUtils {
    public static ExecutionCallback getEmptyTransactionCallback(final MuleEvent returnObject) {
        return new ExecutionCallback<MuleEvent>(){

            public MuleEvent process() throws Exception {
                return returnObject;
            }
        };
    }

    public static ExecutionCallback<MuleEvent> getRollbackTransactionCallback(final MuleEvent returnObject) {
        return new ExecutionCallback(){

            public MuleEvent process() throws Exception {
                TransactionCoordination.getInstance().getTransaction().setRollbackOnly();
                return returnObject;
            }
        };
    }

    public static ExecutionCallback<MuleEvent> getFailureTransactionCallback() throws Exception {
        return new ExecutionCallback<MuleEvent>(){

            public MuleEvent process() throws Exception {
                throw (MessagingException)Mockito.mock(MessagingException.class, (Answer)Answers.RETURNS_MOCKS.get());
            }
        };
    }

    public static ExecutionCallback<MuleEvent> getFailureTransactionCallback(final MessagingException mockMessagingException) throws Exception {
        return new ExecutionCallback<MuleEvent>(){

            public MuleEvent process() throws Exception {
                throw mockMessagingException;
            }
        };
    }

    public static ExecutionCallback<MuleEvent> getFailureTransactionCallbackStartsTransaction(final MessagingException mockMessagingException, final Transaction mockTransaction) {
        return new ExecutionCallback<MuleEvent>(){

            public MuleEvent process() throws Exception {
                TransactionCoordination.getInstance().bindTransaction(mockTransaction);
                throw mockMessagingException;
            }
        };
    }
}

