/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.ListMessageSplitter;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.MuleEventCheckAnswer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;

public class ListMessageSplitterTestCase
extends AbstractMuleContextTestCase {
    public ListMessageSplitterTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testCorrelationGroupSizePropertySet() throws Exception {
        Service testService = ListMessageSplitterTestCase.getTestService("test", Apple.class);
        MuleSession session = ListMessageSplitterTestCase.getTestSession(testService, muleContext);
        OutboundEndpoint endpoint = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test1Endpoint", "test://endpoint?exchangePattern=request-response");
        ListMessageSplitter router = new ListMessageSplitter();
        router.setFilter(null);
        router.addRoute((MessageProcessor)endpoint);
        router.setMuleContext(muleContext);
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("one");
        payload.add("two");
        payload.add("three");
        payload.add("four");
        DefaultMuleMessage message = new DefaultMuleMessage(payload, muleContext);
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        Assert.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((boolean)(resultMessage instanceof MuleMessageCollection));
        Assert.assertEquals((String)"There should be 4 results for 4 split messages.", (long)4L, (long)((MuleMessageCollection)resultMessage).size());
    }

    @Test
    public void testMessageSplitterRouter() throws Exception {
        OutboundEndpoint endpoint1 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test1endpoint", "test://endpointUri.1", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        OutboundEndpoint endpoint3 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3");
        OutboundEndpoint mockendpoint3 = RouterTestUtils.createMockEndpoint(endpoint3);
        OutboundEndpoint endpoint4 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test4endpoint", "test://endpointUri.4?exchangePattern=request-response", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        OutboundEndpoint mockendpoint4 = RouterTestUtils.createMockEndpoint(endpoint4);
        OutboundEndpoint endpoint5 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test5Endpoint", "test://endpointUri.5?exchangePattern=request-response", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        OutboundEndpoint mockendpoint5 = RouterTestUtils.createMockEndpoint(endpoint5);
        OutboundEndpoint endpoint6 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test6Endpoint", "test://endpointUri.6?exchangePattern=request-response");
        OutboundEndpoint mockendpoint6 = RouterTestUtils.createMockEndpoint(endpoint6);
        ListMessageSplitter asyncSplitter = new ListMessageSplitter();
        asyncSplitter.setMuleContext(muleContext);
        asyncSplitter.setDisableRoundRobin(true);
        asyncSplitter.setFilter((Filter)new PayloadTypeFilter(List.class));
        asyncSplitter.addRoute((MessageProcessor)mockendpoint1);
        asyncSplitter.addRoute((MessageProcessor)mockendpoint2);
        asyncSplitter.addRoute((MessageProcessor)mockendpoint3);
        ListMessageSplitter syncSplitter = new ListMessageSplitter();
        syncSplitter.setMuleContext(muleContext);
        syncSplitter.setDisableRoundRobin(true);
        syncSplitter.setFilter((Filter)new PayloadTypeFilter(List.class));
        syncSplitter.addRoute((MessageProcessor)mockendpoint4);
        syncSplitter.addRoute((MessageProcessor)mockendpoint5);
        syncSplitter.addRoute((MessageProcessor)mockendpoint6);
        ArrayList<Object> payload = new ArrayList<Object>();
        payload.add(new Apple());
        payload.add(new Apple());
        payload.add(new Orange());
        payload.add("");
        DefaultMuleMessage message = new DefaultMuleMessage(payload, muleContext);
        Assert.assertTrue((boolean)asyncSplitter.isMatch((MuleMessage)message));
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        Mockito.when((Object)mockendpoint3.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        asyncSplitter.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        message = new DefaultMuleMessage(payload, muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        Mockito.when((Object)mockendpoint4.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        Mockito.when((Object)mockendpoint5.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        Mockito.when((Object)mockendpoint6.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        MuleEvent result = syncSplitter.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        Assert.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((boolean)(resultMessage instanceof MuleMessageCollection));
        Assert.assertEquals((long)4L, (long)((MuleMessageCollection)resultMessage).size());
    }
}

