/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.WireTap;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class WireTapTestCase
extends AbstractMuleContextTestCase {
    protected SensingNullMessageProcessor tapListener;
    protected WireTap wireTap;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.wireTap = new WireTap();
        this.tapListener = this.getSensingNullMessageProcessor();
        this.wireTap.setTap((MessageProcessor)this.tapListener);
    }

    @Test
    public void testWireTapNoFilter() throws Exception {
        MuleEvent event = WireTapTestCase.getTestEvent("data");
        MuleEvent primaryOutput = this.wireTap.process(event);
        Assert.assertSame((Object)event, (Object)primaryOutput);
        Assert.assertNotNull((Object)this.tapListener.event);
        Assert.assertEquals((Object)event.getMessage().getPayload(), (Object)this.tapListener.event.getMessage().getPayload());
    }

    @Test
    public void testWireTapFilterAccepted() throws Exception {
        this.wireTap.setFilter(new Filter(){

            public boolean accept(MuleMessage message) {
                return true;
            }
        });
        MuleEvent event = WireTapTestCase.getTestEvent("data");
        MuleEvent primaryOutput = this.wireTap.process(event);
        Assert.assertSame((Object)event, (Object)primaryOutput);
        Assert.assertNotNull((Object)this.tapListener.event);
        Assert.assertEquals((Object)event.getMessage().getPayload(), (Object)this.tapListener.event.getMessage().getPayload());
    }

    @Test
    public void testWireTapFilterUnaccepted() throws Exception {
        this.wireTap.setFilter(new Filter(){

            public boolean accept(MuleMessage message) {
                return false;
            }
        });
        MuleEvent event = WireTapTestCase.getTestEvent("data");
        MuleEvent primaryOutput = this.wireTap.process(event);
        Assert.assertSame((Object)event, (Object)primaryOutput);
        Assert.assertNull((Object)this.tapListener.event);
    }

    @Test
    public void testWireTapNullTap() throws Exception {
        this.wireTap.setTap(null);
        MuleEvent event = WireTapTestCase.getTestEvent("data");
        MuleEvent primaryOutput = this.wireTap.process(event);
        Assert.assertSame((Object)event, (Object)primaryOutput);
    }
}

