/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.routing.MessageChunkAggregator;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class MessageChunkAggregatorTestCase
extends AbstractMuleContextTestCase {
    public MessageChunkAggregatorTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testMessageProcessor() throws Exception {
        MuleSession session = MessageChunkAggregatorTestCase.getTestSession(null, muleContext);
        Service testService = MessageChunkAggregatorTestCase.getTestService("test", Apple.class);
        Assert.assertNotNull((Object)testService);
        MessageChunkAggregator router = new MessageChunkAggregator();
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", muleContext);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", muleContext);
        message1.setCorrelationId(message1.getUniqueId());
        message2.setCorrelationId(message1.getUniqueId());
        message3.setCorrelationId(message1.getUniqueId());
        message1.setCorrelationGroupSize(3);
        InboundEndpoint endpoint = MuleTestUtils.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, endpoint, (FlowConstruct)MessageChunkAggregatorTestCase.getTestService(), session);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, endpoint, (FlowConstruct)MessageChunkAggregatorTestCase.getTestService(), session);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)message3, endpoint, (FlowConstruct)MessageChunkAggregatorTestCase.getTestService(), session);
        Assert.assertNull((Object)router.process((MuleEvent)event1));
        Assert.assertNull((Object)router.process((MuleEvent)event2));
        MuleEvent resultEvent = router.process((MuleEvent)event3);
        Assert.assertNotNull((Object)resultEvent);
        MuleMessage resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        String payload = resultMessage.getPayloadAsString();
        Assert.assertTrue((boolean)payload.contains("test event A"));
        Assert.assertTrue((boolean)payload.contains("test event B"));
        Assert.assertTrue((boolean)payload.contains("test event C"));
        Assert.assertTrue((boolean)payload.matches("test event [A,B,C]test event [A,B,C]test event [A,B,C]"));
    }
}

