/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.transport.PropertyScope;
import org.mule.expression.MessageHeadersListExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MessageHeadersListExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private HashMap<String, Object> messageProperties;
    private MessageHeadersListExpressionEvaluator evaluator = new MessageHeadersListExpressionEvaluator();
    private MuleMessage message;

    public MessageHeadersListExpressionEvaluatorTestCase() {
        this.setDisposeContextPerClass(true);
    }

    @Override
    public void doSetUp() {
        this.messageProperties = new HashMap(3);
        this.messageProperties.put("foo", "foovalue");
        this.messageProperties.put("bar", "barvalue");
        this.messageProperties.put("baz", "bazvalue");
        this.message = new DefaultMuleMessage((Object)"Test Message", this.messageProperties, muleContext);
    }

    @Test
    public void requiredHeadersWithExitingValueShouldReturnValue() {
        Object result = this.evaluator.evaluate("foo, baz", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
        Assert.assertFalse((boolean)list.contains("barvalue"));
    }

    @Test
    public void requiredHeadersWithExistingValuesViaExpressionManagerShouldReturnValue() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:foo, baz]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
        Assert.assertFalse((boolean)list.contains("barvalue"));
    }

    @Test(expected=RequiredValueException.class)
    public void requiredHeadersWithMissingValuesShouldFail() {
        this.evaluator.evaluate("nonexistent", this.message);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredHeadersWithMissingValuesViaExpressionManagerShouldFail() {
        muleContext.getExpressionManager().evaluate("#[headers-list:nonexistent]", this.message);
    }

    @Test
    public void optionalHeadersWithExistingValuesShouldReturnValues() {
        Object result = this.evaluator.evaluate("foo?, baz?", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
        Assert.assertFalse((boolean)list.contains("barvalue"));
    }

    @Test
    public void optionalHeadersWithExistingValuesViaExpressionManagerShouldReturnValues() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:foo?, baz]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
        Assert.assertFalse((boolean)list.contains("barvalue"));
    }

    @Test
    public void optionalHeadersWithMissingValuesShouldReturnEmptyList() throws Exception {
        Object result = this.evaluator.evaluate("fool?", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void optionalHeadersWithMissingValuesViaExpressionManagerShouldReturnEmptyList() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:nonexistent?]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void requiredHeadersWithExplicitScopeShouldReturnValues() {
        Object result = this.evaluator.evaluate("OUTBOUND:foo, OUTBOUND:baz", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
        Assert.assertFalse((boolean)list.contains("barvalue"));
    }

    @Test
    public void propertyScopeSpecifiedForOneKeyShouldSetScopeForAllOtherKeys() {
        Object result = this.evaluator.evaluate("OUTBOUND:foo, baz", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
    }

    @Test
    public void propertiesFromDifferentScopesWithValuesShouldReturnValues() {
        this.message.setProperty("faz", (Object)"fazvalue", PropertyScope.INVOCATION);
        Object result = this.evaluator.evaluate("OUTBOUND:foo, OUTBOUND:baz, INVOCATION:faz", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
        Assert.assertTrue((boolean)list.contains("fazvalue"));
    }

    @Test
    public void matchAllWildcardShouldReturnAllHeaderValues() {
        Object result = this.evaluator.evaluate("*", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
        Assert.assertTrue((boolean)list.contains("barvalue"));
    }

    @Test
    public void matchAllWildcardViaExpressionManagerShouldReturnAllHeaderValues() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:*]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
        Assert.assertTrue((boolean)list.contains("barvalue"));
    }

    @Test
    public void matchBeginningWildcardShouldReturnValues() {
        Object result = this.evaluator.evaluate("ba*", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("barvalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
    }

    @Test
    public void matchBeginningWildcardViaExpressionManagerShouldReturnValues() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:ba*]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertFalse((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
        Assert.assertTrue((boolean)list.contains("barvalue"));
    }

    @Test
    public void wildcardWithNoMatchShouldReturnEmptyList() {
        Object result = this.evaluator.evaluate("x*", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void wildcardWithNoMatchViaExpressionManagerShouldReturnEmptyList() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:x*]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void multipleWildcardsShouldReturnValues() throws Exception {
        Object result = this.evaluator.evaluate("ba*, f*", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
        Assert.assertTrue((boolean)list.contains("barvalue"));
    }

    @Test
    public void multipleWildcardsViaExpressionManagerShouldReturnValues() {
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:ba*, f*]", this.message);
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foovalue"));
        Assert.assertTrue((boolean)list.contains("bazvalue"));
        Assert.assertTrue((boolean)list.contains("barvalue"));
    }
}

