/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.el.mvel.MVELExpressionExecutor;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;
import org.objectweb.asm.ClassWriter;

@SmallTest
public class MVELExpressionExecutorTestCase
extends AbstractMuleTestCase {
    protected MVELExpressionExecutor mvel;
    protected MVELExpressionLanguageContext context;

    @Before
    public void setupMVEL() throws InitialisationException {
        this.mvel = new MVELExpressionExecutor(new ParserContext());
        this.context = (MVELExpressionLanguageContext)Mockito.mock(MVELExpressionLanguageContext.class);
        Mockito.when((Object)this.context.isResolveable(Mockito.anyString())).thenReturn((Object)false);
    }

    @Test
    public void evaluateReturnInt() {
        Assert.assertEquals((Object)4, (Object)this.mvel.execute("2*2", null));
    }

    @Test
    public void evaluateReturnString() {
        Assert.assertEquals((Object)"hi", (Object)this.mvel.execute("'hi'", null));
    }

    @Test(expected=CompileException.class)
    public void evaluateInvalidExpression() {
        Assert.assertEquals((Object)4, (Object)this.mvel.execute("2*'2", null));
    }

    @Test(expected=CompileException.class)
    public void invalidExpression() {
        this.mvel.validate("a9-#'");
    }

    @Test
    public void validExpression() {
        this.mvel.validate("var a = 2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useContextClassLoader() throws ClassNotFoundException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new MyClassClassLoader());
            Assert.assertFalse((boolean)((Boolean)this.mvel.execute("1 is org.MyClass", null)));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    static class MyClassClassLoader
    extends ClassLoader {
        MyClassClassLoader() {
        }

        @Override
        protected Class<?> findClass(String className) throws ClassNotFoundException {
            if (className.equals("org.MyClass")) {
                ClassWriter cw = new ClassWriter(2);
                cw.visit(49, 1, "org/MyClass", null, "java/lang/Object", null);
                return this.defineClass(className, cw.toByteArray(), 0, cw.toByteArray().length);
            }
            return super.findClass(className);
        }
    }
}

