/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.datetime;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.el.datetime.Instant;
import org.mule.el.datetime.DateTime;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DateTimeDateTestCase
extends AbstractMuleTestCase {
    protected org.mule.api.el.datetime.Date now = new DateTime().withTimeZone("UTC").getDate();

    @Test
    public void isBefore() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        junit.framework.Assert.assertTrue((boolean)this.now.isBefore((Instant)new DateTime(cal).withTimeZone("UTC")));
    }

    @Test
    public void isAfter() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        junit.framework.Assert.assertTrue((boolean)this.now.isAfter((Instant)new DateTime(cal).withTimeZone("UTC")));
    }

    @Test
    public void format() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        junit.framework.Assert.assertEquals((String)df.format(this.now.toDate()), (String)this.now.format("EEE, MMM d, yyyy"));
    }

    @Test
    public void timeZone() {
        junit.framework.Assert.assertEquals((String)TimeZone.getTimeZone("UTC").getDisplayName(), (String)this.now.getTimeZone());
    }

    @Test
    public void plusDays() {
        junit.framework.Assert.assertEquals((int)((Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(6) + 1) % 365), (int)this.now.plusDays(1).getDayOfYear());
    }

    @Test
    public void plusWeeks() {
        junit.framework.Assert.assertEquals((int)((Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(3) + 1) % 52), (int)this.now.plusWeeks(1).getWeekOfYear());
    }

    @Test
    public void plusMonths() {
        junit.framework.Assert.assertEquals((int)((Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(2) + 2) % 12), (int)this.now.plusMonths(1).getMonth());
    }

    @Test
    public void plusYears() {
        junit.framework.Assert.assertEquals((int)(Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(1) + 1), (int)this.now.plusYears(1).getYear());
    }

    @Test
    public void withLocale() {
        SimpleDateFormat df = new SimpleDateFormat("E");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        Assert.assertEquals((Object)df.format(new Date()), (Object)this.now.withLocale("en_US").format("E"));
    }

    @Test
    public void dayOfWeek() {
        Assert.assertEquals((long)Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(7), (long)this.now.getDayOfWeek());
    }

    @Test
    public void dayOfMonth() {
        Assert.assertEquals((long)Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(5), (long)this.now.getDayOfMonth());
    }

    @Test
    public void dayOfYear() {
        Assert.assertEquals((long)Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(6), (long)this.now.getDayOfYear());
    }

    @Test
    public void weekOfMonth() {
        Assert.assertEquals((long)Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(4), (long)this.now.getWeekOfMonth());
    }

    @Test
    public void weekOfYear() {
        Assert.assertEquals((long)Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(3), (long)this.now.getWeekOfYear());
    }

    @Test
    public void monthOfYear() {
        Assert.assertEquals((long)(Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(2) + 1), (long)this.now.getMonth());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)DatatypeConverter.printDate((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC"))), (Object)this.now.toString());
    }

    @Test
    public void toDate() {
        Assert.assertEquals(Date.class, this.now.toDate().getClass());
    }

    @Test
    public void toCalendar() {
        Assert.assertEquals(GregorianCalendar.class, this.now.toCalendar().getClass());
    }

    @Test
    public void toXMLCalendar() throws DatatypeConfigurationException {
        Assert.assertTrue((boolean)(this.now.toXMLCalendar() instanceof XMLGregorianCalendar));
    }

    @Test
    public void fromDate() {
        Date date = new Date();
        date.setYear(0);
        date.setMonth(0);
        date.setDate(1);
        Assert.assertEquals((long)1900L, (long)new DateTime(date).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime(date).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime(date).getDayOfMonth());
    }

    @Test
    public void fromCalendar() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 1900);
        cal.set(2, 0);
        cal.set(5, 1);
        Assert.assertEquals((long)1900L, (long)new DateTime((Calendar)cal).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime((Calendar)cal).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime((Calendar)cal).getDayOfMonth());
    }

    @Test
    public void fromXMLCalendar() throws DatatypeConfigurationException {
        XMLGregorianCalendar xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        xmlCal.setYear(1900);
        xmlCal.setMonth(1);
        xmlCal.setDay(1);
        Assert.assertEquals((long)1900L, (long)new DateTime(xmlCal).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime(xmlCal).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime(xmlCal).getDayOfMonth());
    }
}

