/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.LocaleUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.el.context.AbstractELTestCase;
import org.mule.el.datetime.DateTime;

public class ServerContextTestCase
extends AbstractELTestCase {
    public ServerContextTestCase(AbstractELTestCase.Variant variant) {
        super(variant);
    }

    @Test
    public void host() throws UnknownHostException {
        junit.framework.Assert.assertEquals((Object)InetAddress.getLocalHost().getCanonicalHostName(), (Object)this.evaluate("server.host"));
    }

    @Test
    public void assignValueToHost() {
        this.assertFinalProperty("server.host='1'");
    }

    @Test
    public void ip() throws UnknownHostException {
        junit.framework.Assert.assertEquals((Object)InetAddress.getLocalHost().getHostAddress(), (Object)this.evaluate("server.ip"));
    }

    @Test
    public void assignValueToIp() {
        this.assertFinalProperty("server.ip='1'");
    }

    @Test
    public void javaSystemProperties() {
        junit.framework.Assert.assertEquals((Object)System.getProperties(), (Object)this.evaluate("server.systemProperties"));
    }

    @Test
    public void assignValueToJavaSystemProperties() {
        this.assertFinalProperty("server.systemProperties='1'");
    }

    @Test
    public void tmpDir() {
        junit.framework.Assert.assertEquals((Object)System.getProperty("java.io.tmpdir"), (Object)this.evaluate("server.tmpDir"));
    }

    @Test
    public void assignValueToTmpdir() {
        this.assertFinalProperty("server.tmpDir='1'");
    }

    @Test
    public void fileSeperator() {
        junit.framework.Assert.assertEquals((Object)System.getProperty("file.separator"), (Object)this.evaluate("server.fileSeparator"));
    }

    @Test
    public void assignValueToFileseperator() {
        this.assertFinalProperty("server.fileSeparator='1'");
    }

    @Test
    public void osName() {
        junit.framework.Assert.assertEquals((Object)System.getProperty("os.name"), (Object)this.evaluate("server.osName"));
    }

    @Test
    public void assignValueToOsName() {
        this.assertFinalProperty("server.osName='1'");
    }

    @Test
    public void osArch() {
        junit.framework.Assert.assertEquals((Object)System.getProperty("os.arch"), (Object)this.evaluate("server.osArch"));
    }

    @Test
    public void assignValueToOsArch() {
        this.assertFinalProperty("server.osArch='1'");
    }

    @Test
    public void osVersion() {
        junit.framework.Assert.assertEquals((Object)System.getProperty("os.version"), (Object)this.evaluate("server.osVersion"));
    }

    @Test
    public void assignValueToOsVersion() {
        this.assertFinalProperty("server.os.version='1'");
    }

    @Test
    public void javaVersion() {
        junit.framework.Assert.assertEquals((Object)System.getProperty("java.version"), (Object)this.evaluate("server.javaVersion"));
    }

    @Test
    public void assignValueToJavaVersion() {
        this.assertFinalProperty("server.javaVersion='1'");
    }

    @Test
    public void javaVendor() {
        junit.framework.Assert.assertEquals((Object)System.getProperty("java.vendor"), (Object)this.evaluate("server.javaVendor"));
    }

    @Test
    public void assignValueToJavaVendor() {
        this.assertFinalProperty("server.javaVendor='1'");
    }

    @Test
    public void env() {
        junit.framework.Assert.assertEquals(System.getenv(), (Object)this.evaluate("server.env"));
    }

    @Test
    public void assignValueToEnv() {
        this.assertFinalProperty("server.env='1'");
    }

    @Test
    public void timeZone() {
        junit.framework.Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone"));
    }

    @Test
    public void assignValueToTimeZone() {
        this.assertFinalProperty("server.timeZone='1'");
    }

    @Test
    public void locale() {
        junit.framework.Assert.assertEquals((Object)Locale.getDefault(), (Object)this.evaluate("server.locale"));
    }

    @Test
    public void assignValueToLocal() {
        this.assertFinalProperty("server.locale='1'");
    }

    @Test
    public void userName() {
        junit.framework.Assert.assertEquals((Object)System.getProperty("user.name"), (Object)this.evaluate("server.userName"));
    }

    @Test
    public void assignValueToUserName() {
        this.assertFinalProperty("server.userName='1'");
    }

    @Test
    public void userHome() {
        junit.framework.Assert.assertEquals((Object)System.getProperty("user.home"), (Object)this.evaluate("server.userHome"));
    }

    @Test
    public void assignValueToUserHome() {
        this.assertFinalProperty("server.userHome='1'");
    }

    @Test
    public void userDir() {
        junit.framework.Assert.assertEquals((Object)System.getProperty("user.dir"), (Object)this.evaluate("server.userDir"));
    }

    @Test
    public void assignValueToUserDir() {
        this.assertFinalProperty("server.userDir='1'");
    }

    @Test
    public void dateTime() {
        junit.framework.Assert.assertEquals(DateTime.class, this.evaluate("server.dateTime").getClass());
    }

    @Test
    public void assignValueToDateTime() {
        this.assertFinalProperty("server.dateTime='1'");
    }

    @Test
    public void dateTimeMilliSeconds() {
        junit.framework.Assert.assertTrue(((Long)this.evaluate("server.dateTime.milliSeconds") < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void dateTimeIsBefore() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new DateTime(cal), muleContext);
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("server.dateTime.isBefore(payload)", (MuleMessage)message)));
    }

    @Test
    public void dateTimeIsAfter() {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new DateTime(Calendar.getInstance()), muleContext);
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("server.dateTime.isAfter(payload)", (MuleMessage)message)));
    }

    @Test
    public void dateTimeFormat() {
        junit.framework.Assert.assertEquals((Object)new SimpleDateFormat("EEE, MMM d, yyyy").format(new Date()), (Object)this.evaluate("server.dateTime.format('EEE, MMM d, yyyy')"));
        junit.framework.Assert.assertEquals((Object)new SimpleDateFormat("EEE, MMM d, yyyy", LocaleUtils.toLocale((String)"en_US")).format(new Date()), (Object)this.evaluate("server.dateTime.withLocale('en_US').format('EEE, MMM d, yyyy')"));
    }

    @Test
    public void dateTimeZone() {
        junit.framework.Assert.assertEquals((Object)TimeZone.getDefault().getDisplayName(), (Object)this.evaluate("server.dateTime.timeZone"));
    }

    @Test
    public void dateTimeAddSeconds() {
        junit.framework.Assert.assertEquals((Object)((Calendar.getInstance().get(13) + 1) % 60), (Object)this.evaluate("(int) server.dateTime.plusSeconds(1).format('s')"));
    }

    @Test
    public void dateTimeAddMinutes() {
        junit.framework.Assert.assertEquals((Object)((Calendar.getInstance().get(12) + 1) % 60), (Object)this.evaluate("server.dateTime.plusMinutes(1).minutes"));
    }

    @Test
    public void dateTimeAddHours() {
        junit.framework.Assert.assertEquals((Object)((Calendar.getInstance().get(11) + 1) % 24), (Object)this.evaluate("server.dateTime.plusHours(1).hours"));
    }

    @Test
    public void dateTimeAddDays() {
        junit.framework.Assert.assertEquals((Object)((Calendar.getInstance().get(6) + 1) % 365), (Object)this.evaluate("(int) server.dateTime.plusDays(1).dayOfYear"));
    }

    @Test
    public void dateTimeAddWeeks() {
        junit.framework.Assert.assertEquals((Object)((Calendar.getInstance().get(3) + 1) % 52), (Object)this.evaluate("(int) server.dateTime.plusWeeks(1).weekOfYear"));
    }

    @Test
    public void dateTimeAddMonths() {
        junit.framework.Assert.assertEquals((Object)((Calendar.getInstance(Locale.US).get(2) + 2) % 12), (Object)this.evaluate("(int) server.dateTime.plusMonths(1).month"));
    }

    @Test
    public void dateTimeAddYears() {
        junit.framework.Assert.assertEquals((Object)(Calendar.getInstance(Locale.US).get(1) + 1), (Object)this.evaluate("(int) server.dateTime.plusYears(1).format('yyyy')"));
    }

    @Test
    public void dateTimeWithTimeZone() {
        Assert.assertEquals((Object)"Central European Time", (Object)this.evaluate("server.dateTime.withTimeZone('CET').timeZone"));
    }

    @Test
    public void dateTimeWithLocale() {
        Assert.assertEquals((Object)new SimpleDateFormat("E").format(new Date()), (Object)this.evaluate("server.dateTime.withLocale('en_US').format('E')"));
        Assert.assertEquals((Object)new SimpleDateFormat("E", LocaleUtils.toLocale((String)"es_AR")).format(new Date()), (Object)this.evaluate("server.dateTime.withLocale('es_AR').format('E')"));
    }

    @Test
    public void dateTimeSeconds() {
        Assert.assertEquals((Object)Calendar.getInstance().get(13), (Object)this.evaluate("server.dateTime.seconds"));
    }

    @Test
    public void dateTimeMinutes() {
        Assert.assertEquals((Object)Calendar.getInstance().get(12), (Object)this.evaluate("server.dateTime.minutes"));
    }

    @Test
    public void dateTimeHour() {
        Assert.assertEquals((Object)Calendar.getInstance().get(11), (Object)this.evaluate("server.dateTime.hours"));
    }

    @Test
    public void dateTimeDayOfWeek() {
        Assert.assertEquals((Object)Calendar.getInstance().get(7), (Object)this.evaluate("server.dateTime.dayOfWeek"));
    }

    @Test
    public void dateTimeDayOfMonth() {
        Assert.assertEquals((Object)Calendar.getInstance().get(5), (Object)this.evaluate("server.dateTime.dayOfMonth"));
    }

    @Test
    public void dateTimeDayOfYear() {
        Assert.assertEquals((Object)Calendar.getInstance().get(6), (Object)this.evaluate("server.dateTime.dayOfYear"));
    }

    @Test
    public void dateTimeWeekOfMonth() {
        Assert.assertEquals((Object)Calendar.getInstance().get(4), (Object)this.evaluate("server.dateTime.weekOfMonth"));
    }

    @Test
    public void dateTimeWeekOfYear() {
        Assert.assertEquals((Object)Calendar.getInstance().get(3), (Object)this.evaluate("server.dateTime.weekOfYear"));
    }

    @Test
    public void dateTimeMonthOfYear() {
        Assert.assertEquals((Object)(Calendar.getInstance().get(2) + 1), (Object)this.evaluate("server.dateTime.month"));
    }

    @Test
    public void dateTimeToString() {
        Assert.assertEquals((Object)DatatypeConverter.printDateTime((Calendar)Calendar.getInstance()).substring(0, 18), (Object)this.evaluate("server.dateTime").toString().substring(0, 18));
    }
}

