/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.BsonTypeInfo;
import com.mongodb.jdbc.MongoColumnInfo;
import com.mongodb.jdbc.MongoJsonSchema;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonType;
import org.bson.BsonValue;

@AutoLoggable
public class MongoResultSetMetaData
implements ResultSetMetaData,
LoggingAspect$ajcMightHaveAspect {
    private Map<String, DatasourceAndIndex> columnLabels;
    private List<NameSpace> columnIndices;
    private List<MongoColumnInfo> columnInfo;
    protected final int UNKNOWN_LENGTH = 0;
    protected MongoLogger logger;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    public MongoResultSetMetaData(MongoJsonSchema schema, boolean sortFieldsAlphabetically, MongoLogger parentLogger, Integer statementId) throws SQLException {
        LoggingAspect.ajc$perObjectBind(this);
        this.UNKNOWN_LENGTH = 0;
        MongoLogger mongoLogger = statementId == null ? new MongoLogger(this.getClass().getCanonicalName(), parentLogger) : new MongoLogger(this.getClass().getCanonicalName(), parentLogger, statementId);
        MongoResultSetMetaData mongoResultSetMetaData = this;
        if (LoggingAspect.hasAspect(this)) {
            MongoResultSetMetaData.logger_aroundBody1$advice(this, mongoResultSetMetaData, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            mongoResultSetMetaData.logger = mongoLogger;
        }
        this.assertDatasourceSchema(schema);
        this.columnLabels = new HashMap<String, DatasourceAndIndex>();
        this.columnIndices = new ArrayList<NameSpace>();
        this.columnInfo = new ArrayList<MongoColumnInfo>();
        Object[] datasources = schema.properties.keySet().toArray(new String[0]);
        Arrays.sort(datasources);
        Object[] objectArray = datasources;
        int n = datasources.length;
        int n2 = 0;
        while (n2 < n) {
            Object datasource = objectArray[n2];
            this.processDataSource(schema, (String)datasource, sortFieldsAlphabetically);
            ++n2;
        }
    }

    private void assertDatasourceSchema(MongoJsonSchema schema) throws SQLException {
        try {
            if (!schema.isObject() || schema.properties == null) {
                throw new SQLException("ResultSetMetaData json schema must be object with properties");
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    private void processDataSource(MongoJsonSchema schema, String datasource, boolean sortFieldsAlphabetically) throws SQLException {
        try {
            MongoJsonSchema datasourceSchema = schema.properties.get(datasource);
            this.assertDatasourceSchema(datasourceSchema);
            Object[] fields = datasourceSchema.properties.keySet().toArray(new String[0]);
            if (sortFieldsAlphabetically) {
                Arrays.sort(fields);
            }
            Object[] objectArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Object field = objectArray[n2];
                MongoJsonSchema columnSchema = datasourceSchema.properties.get(field);
                BsonTypeInfo columnBsonTypeInfo = columnSchema.getBsonTypeInfo();
                int nullability = datasourceSchema.getColumnNullability((String)field);
                this.columnIndices.add(new NameSpace(datasource, (String)field));
                this.columnInfo.add(new MongoColumnInfo(datasource, (String)field, columnBsonTypeInfo, nullability));
                if (!this.columnLabels.containsKey(field)) {
                    this.columnLabels.put((String)field, new DatasourceAndIndex(datasource, this.columnIndices.size() - 1));
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    protected String getDatasource(String columnLabel) {
        try {
            return this.columnLabels.get((Object)columnLabel).datasource;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    protected void checkBounds(int i) throws SQLException {
        try {
            if (i > this.getColumnCount()) {
                throw new SQLException("Index out of bounds: '" + i + "'.");
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    public MongoColumnInfo getColumnInfo(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkBounds(column);
            return this.columnInfo.get(column - 1);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkBounds(column);
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkBounds(column);
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkBounds(column);
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkBounds(column);
            return "";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this));
            }
            return this.columnIndices.size();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    public boolean hasColumnWithLabel(String label) {
        String string = label;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string));
            }
            return this.columnLabels.containsKey(label);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    public int getColumnPositionFromLabel(String label) {
        String string = label;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string));
            }
            return this.columnLabels.get((Object)label).index;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkBounds(column);
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkBounds(column);
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_13);
            }
            throw exception;
        }
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkBounds(column);
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_14);
            }
            throw exception;
        }
    }

    @Override
    public int isNullable(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            return this.getColumnInfo(column).getNullability();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_15);
            }
            throw exception;
        }
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            return this.getColumnInfo(column).getColumnAlias();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_16);
            }
            throw exception;
        }
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            return this.getColumnInfo(column).getColumnName();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_17);
            }
            throw exception;
        }
    }

    @Override
    public String getTableName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            return this.getColumnInfo(column).getTableAlias();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_18);
            }
            throw exception;
        }
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            return this.getColumnInfo(column).getDatabase();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_19);
            }
            throw exception;
        }
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            return this.getColumnInfo(column).getJDBCType();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_20);
            }
            throw exception;
        }
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            return this.getColumnInfo(column).getBsonTypeName();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_21);
            }
            throw exception;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Class<?> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, clazz));
            }
            return iface.isInstance(this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_22);
            }
            throw exception;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Class<T> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, clazz));
            }
            return (T)this;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_23);
            }
            throw exception;
        }
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        int n = column;
        try {
            MongoColumnInfo ci;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            if ((ci = this.getColumnInfo(column)).isPolymorphic()) {
                return true;
            }
            BsonType t = ci.getBsonTypeEnum();
            switch (t) {
                case DOUBLE: 
                case DOCUMENT: 
                case ARRAY: 
                case BINARY: 
                case UNDEFINED: 
                case OBJECT_ID: 
                case BOOLEAN: 
                case DATE_TIME: 
                case NULL: 
                case DB_POINTER: 
                case INT32: 
                case TIMESTAMP: 
                case INT64: 
                case DECIMAL128: 
                case MIN_KEY: 
                case MAX_KEY: {
                    return false;
                }
                case STRING: 
                case REGULAR_EXPRESSION: 
                case JAVASCRIPT: 
                case SYMBOL: 
                case JAVASCRIPT_WITH_SCOPE: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_24);
            }
            throw exception;
        }
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        int n = column;
        try {
            MongoColumnInfo ci;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            if ((ci = this.getColumnInfo(column)).isPolymorphic()) {
                return true;
            }
            BsonType t = ci.getBsonTypeEnum();
            switch (t) {
                case DOUBLE: 
                case INT32: 
                case INT64: 
                case DECIMAL128: {
                    return true;
                }
                case STRING: 
                case DOCUMENT: 
                case ARRAY: 
                case BINARY: 
                case UNDEFINED: 
                case OBJECT_ID: 
                case BOOLEAN: 
                case DATE_TIME: 
                case NULL: 
                case REGULAR_EXPRESSION: 
                case DB_POINTER: 
                case JAVASCRIPT: 
                case SYMBOL: 
                case JAVASCRIPT_WITH_SCOPE: 
                case TIMESTAMP: 
                case MIN_KEY: 
                case MAX_KEY: {
                    return false;
                }
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_25);
            }
            throw exception;
        }
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int n = column;
        try {
            MongoColumnInfo ci;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            if ((ci = this.getColumnInfo(column)).isPolymorphic()) {
                return 0;
            }
            BsonType t = ci.getBsonTypeEnum();
            switch (t) {
                case ARRAY: {
                    return 0;
                }
                case BINARY: {
                    return 0;
                }
                case BOOLEAN: {
                    return 1;
                }
                case DATE_TIME: {
                    return 24;
                }
                case DB_POINTER: {
                    return 0;
                }
                case DECIMAL128: {
                    return 34;
                }
                case DOCUMENT: {
                    return 0;
                }
                case DOUBLE: {
                    return 15;
                }
                case INT32: {
                    return 10;
                }
                case INT64: {
                    return 19;
                }
                case JAVASCRIPT: {
                    return 0;
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return 0;
                }
                case MAX_KEY: {
                    return 0;
                }
                case MIN_KEY: {
                    return 0;
                }
                case NULL: {
                    return 0;
                }
                case OBJECT_ID: {
                    return 24;
                }
                case REGULAR_EXPRESSION: {
                    return 0;
                }
                case STRING: {
                    return 0;
                }
                case SYMBOL: {
                    return 0;
                }
                case TIMESTAMP: {
                    return 0;
                }
                case UNDEFINED: {
                    return 0;
                }
            }
            throw new SQLException("unknown bson type: " + t);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_26);
            }
            throw exception;
        }
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int n = column;
        try {
            MongoColumnInfo ci;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            if ((ci = this.getColumnInfo(column)).isPolymorphic()) {
                return 0;
            }
            BsonType t = ci.getBsonTypeEnum();
            switch (t) {
                case ARRAY: {
                    return 0;
                }
                case BINARY: {
                    return 0;
                }
                case BOOLEAN: {
                    return 1;
                }
                case DATE_TIME: {
                    return 24;
                }
                case DB_POINTER: {
                    return 0;
                }
                case DECIMAL128: {
                    return 34;
                }
                case DOCUMENT: {
                    return 0;
                }
                case DOUBLE: {
                    return 15;
                }
                case INT32: {
                    return 10;
                }
                case INT64: {
                    return 19;
                }
                case JAVASCRIPT: {
                    return 0;
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return 0;
                }
                case MAX_KEY: {
                    return 0;
                }
                case MIN_KEY: {
                    return 0;
                }
                case NULL: {
                    return 0;
                }
                case OBJECT_ID: {
                    return 24;
                }
                case REGULAR_EXPRESSION: {
                    return 0;
                }
                case STRING: {
                    return 0;
                }
                case SYMBOL: {
                    return 0;
                }
                case TIMESTAMP: {
                    return 0;
                }
                case UNDEFINED: {
                    return 0;
                }
            }
            throw new SQLException("unknown bson type: " + t);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_27);
            }
            throw exception;
        }
    }

    @Override
    public int getScale(int column) throws SQLException {
        int n = column;
        try {
            MongoColumnInfo ci;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            if ((ci = this.getColumnInfo(column)).isPolymorphic()) {
                return 0;
            }
            BsonType t = ci.getBsonTypeEnum();
            switch (t) {
                case STRING: 
                case DOCUMENT: 
                case ARRAY: 
                case BINARY: 
                case UNDEFINED: 
                case OBJECT_ID: 
                case BOOLEAN: 
                case DATE_TIME: 
                case NULL: 
                case REGULAR_EXPRESSION: 
                case DB_POINTER: 
                case JAVASCRIPT: 
                case SYMBOL: 
                case JAVASCRIPT_WITH_SCOPE: 
                case INT32: 
                case TIMESTAMP: 
                case INT64: 
                case MIN_KEY: 
                case MAX_KEY: {
                    return 0;
                }
                case DECIMAL128: {
                    return 34;
                }
                case DOUBLE: {
                    return 15;
                }
            }
            throw new SQLException("unknown bson type: " + t);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_28);
            }
            throw exception;
        }
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            String intClassName = Integer.TYPE.getName();
            String booleanClassName = Boolean.TYPE.getName();
            String stringClassName = String.class.getName();
            String floatClassName = Float.TYPE.getName();
            String doubleClassName = Double.TYPE.getName();
            String bigDecimalClassName = BigDecimal.class.getName();
            String timestampClassName = Timestamp.class.getName();
            String bsonClassName = BsonValue.class.getName();
            int columnType = this.getColumnType(column);
            switch (columnType) {
                case 2003: {
                    break;
                }
                case -5: {
                    return intClassName;
                }
                case -2: {
                    break;
                }
                case -7: {
                    return booleanClassName;
                }
                case 2004: {
                    break;
                }
                case 16: {
                    return booleanClassName;
                }
                case 1: {
                    break;
                }
                case 2005: {
                    break;
                }
                case 70: {
                    break;
                }
                case 91: {
                    break;
                }
                case 3: {
                    return bigDecimalClassName;
                }
                case 2001: {
                    break;
                }
                case 8: {
                    return doubleClassName;
                }
                case 6: {
                    return floatClassName;
                }
                case 4: {
                    return intClassName;
                }
                case 2000: {
                    break;
                }
                case -16: {
                    return stringClassName;
                }
                case -4: {
                    break;
                }
                case -1: {
                    return stringClassName;
                }
                case -15: {
                    return stringClassName;
                }
                case 2011: {
                    break;
                }
                case 0: {
                    return null;
                }
                case 2: {
                    return doubleClassName;
                }
                case -9: {
                    return stringClassName;
                }
                case 1111: {
                    return bsonClassName;
                }
                case 7: {
                    break;
                }
                case 2006: {
                    break;
                }
                case 2012: {
                    break;
                }
                case -8: {
                    break;
                }
                case 5: {
                    return intClassName;
                }
                case 2009: {
                    break;
                }
                case 2002: {
                    break;
                }
                case 92: {
                    break;
                }
                case 2013: {
                    break;
                }
                case 93: {
                    return timestampClassName;
                }
                case 2014: {
                    break;
                }
                case -6: {
                    return intClassName;
                }
                case -3: {
                    break;
                }
                case 12: {
                    return stringClassName;
                }
            }
            throw new SQLException("getObject not supported for column type " + columnType);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_29);
            }
            throw exception;
        }
    }

    static {
        MongoResultSetMetaData.ajc$preClinit();
    }

    private static final /* synthetic */ Object logger_aroundBody1$advice(MongoResultSetMetaData ajc$this, MongoResultSetMetaData target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoResultSetMetaData.java", MongoResultSetMetaData.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "assertDatasourceSchema", "com.mongodb.jdbc.MongoResultSetMetaData", "com.mongodb.jdbc.MongoJsonSchema", "schema", "java.sql.SQLException", "void"), 102);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processDataSource", "com.mongodb.jdbc.MongoResultSetMetaData", "com.mongodb.jdbc.MongoJsonSchema:java.lang.String:boolean", "schema:datasource:sortFieldsAlphabetically", "java.sql.SQLException", "void"), 110);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hasColumnWithLabel", "com.mongodb.jdbc.MongoResultSetMetaData", "java.lang.String", "label", "", "boolean"), 180);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnPositionFromLabel", "com.mongodb.jdbc.MongoResultSetMetaData", "java.lang.String", "label", "", "int"), 184);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isReadOnly", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 189);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWritable", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 195);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDefinitelyWritable", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 201);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isNullable", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "int"), 207);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnLabel", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 212);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 217);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTableName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 222);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCatalogName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 227);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getDatasource", "com.mongodb.jdbc.MongoResultSetMetaData", "java.lang.String", "columnLabel", "", "java.lang.String"), 136);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnType", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "int"), 232);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnTypeName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 237);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWrapperFor", "com.mongodb.jdbc.MongoResultSetMetaData", "java.lang.Class", "iface", "java.sql.SQLException", "boolean"), 243);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unwrap", "com.mongodb.jdbc.MongoResultSetMetaData", "java.lang.Class", "iface", "java.sql.SQLException", "java.lang.Object"), 249);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCaseSensitive", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 254);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSigned", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 289);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnDisplaySize", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "int"), 324);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrecision", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "int"), 379);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getScale", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "int"), 433);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnClassName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 470);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "checkBounds", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "i", "java.sql.SQLException", "void"), 140);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnInfo", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "com.mongodb.jdbc.MongoColumnInfo"), 146);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAutoIncrement", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 152);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSearchable", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 158);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCurrency", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "boolean"), 164);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaName", "com.mongodb.jdbc.MongoResultSetMetaData", "int", "column", "java.sql.SQLException", "java.lang.String"), 170);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnCount", "com.mongodb.jdbc.MongoResultSetMetaData", "", "", "java.sql.SQLException", "int"), 176);
    }

    private static class DatasourceAndIndex {
        String datasource;
        int index;

        DatasourceAndIndex(String datasource, int index) {
            this.datasource = datasource;
            this.index = index;
        }
    }

    private static class NameSpace {
        String datasource;
        String columnLabel;

        NameSpace(String datasource, String columnLabel) {
            this.datasource = datasource;
            this.columnLabel = columnLabel;
        }
    }
}

