/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class TimeoutHelper {
    private static final String DEFAULT_TIMEOUT_MESSAGE = "Operation exceeded the timeout limit.";

    private TimeoutHelper() {
    }

    public static <T> MongoCollection<T> collectionWithTimeout(MongoCollection<T> collection, String message, @Nullable Timeout timeout) {
        if (timeout != null) {
            return (MongoCollection)timeout.call(TimeUnit.MILLISECONDS, () -> collection.withTimeout(0L, TimeUnit.MILLISECONDS), ms -> collection.withTimeout(ms, TimeUnit.MILLISECONDS), () -> (MongoCollection)TimeoutContext.throwMongoTimeoutException((String)message));
        }
        return collection;
    }

    public static <T> MongoCollection<T> collectionWithTimeout(MongoCollection<T> collection, @Nullable Timeout timeout) {
        return TimeoutHelper.collectionWithTimeout(collection, DEFAULT_TIMEOUT_MESSAGE, timeout);
    }

    public static MongoDatabase databaseWithTimeout(MongoDatabase database, String message, @Nullable Timeout timeout) {
        if (timeout != null) {
            return (MongoDatabase)timeout.call(TimeUnit.MILLISECONDS, () -> database.withTimeout(0L, TimeUnit.MILLISECONDS), ms -> database.withTimeout(ms, TimeUnit.MILLISECONDS), () -> (MongoDatabase)TimeoutContext.throwMongoTimeoutException((String)message));
        }
        return database;
    }

    public static MongoDatabase databaseWithTimeout(MongoDatabase database, @Nullable Timeout timeout) {
        return TimeoutHelper.databaseWithTimeout(database, DEFAULT_TIMEOUT_MESSAGE, timeout);
    }
}

