/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.SocketSettings;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.DefaultClusterFactory;
import com.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.StreamFactoryFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.lang.Nullable;
import java.util.List;

public final class Clusters {
    private Clusters() {
    }

    public static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactoryFactory streamFactoryFactory) {
        Assertions.assertNotNull((Object)streamFactoryFactory);
        Assertions.assertNotNull((Object)settings);
        StreamFactory streamFactory = Clusters.getStreamFactory(streamFactoryFactory, settings, false);
        StreamFactory heartbeatStreamFactory = Clusters.getStreamFactory(streamFactoryFactory, settings, true);
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), InternalConnectionPoolSettings.builder().build(), TimeoutSettings.create((MongoClientSettings)settings), streamFactory, TimeoutSettings.createHeartbeatSettings((MongoClientSettings)settings), heartbeatStreamFactory, settings.getCredential(), settings.getLoggerSettings(), EventListenerHelper.getCommandListener((List)settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList(), settings.getServerApi(), settings.getDnsClient());
    }

    private static StreamFactory getStreamFactory(StreamFactoryFactory streamFactoryFactory, MongoClientSettings settings, boolean isHeartbeat) {
        SocketSettings socketSettings = isHeartbeat ? settings.getHeartbeatSocketSettings() : settings.getSocketSettings();
        return streamFactoryFactory.create(socketSettings, settings.getSslSettings());
    }
}

