/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.Function;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackBiFunction;
import com.mongodb.internal.async.function.AsyncCallbackFunction;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.async.function.RetryingAsyncCallbackSupplier;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncCommandBatchCursor;
import com.mongodb.internal.operation.AsyncSingleBatchCursor;
import com.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.retry.AttachmentKeys;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

final class AsyncOperationHelper {
    static void withAsyncReadConnectionSource(AsyncReadBinding binding, AsyncCallableWithSource callable) {
        binding.getReadConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithSourceCallback(callable), OperationHelper.LOGGER));
    }

    static void withAsyncConnection(AsyncWriteBinding binding, AsyncCallableWithConnection callable) {
        binding.getWriteConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithConnectionCallback(callable), OperationHelper.LOGGER));
    }

    static <R> void withAsyncSourceAndConnection(AsyncCallbackSupplier<AsyncConnectionSource> sourceSupplier, boolean wrapConnectionSourceException, SingleResultCallback<R> callback, AsyncCallbackBiFunction<AsyncConnectionSource, AsyncConnection, R> asyncFunction) throws OperationHelper.ResourceSupplierInternalException {
        SingleResultCallback<R> errorHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        AsyncOperationHelper.withAsyncSuppliedResource(sourceSupplier, wrapConnectionSourceException, errorHandlingCallback, (source, sourceReleasingCallback) -> AsyncOperationHelper.withAsyncSuppliedResource(source::getConnection, wrapConnectionSourceException, sourceReleasingCallback, (connection, connectionAndSourceReleasingCallback) -> asyncFunction.apply((AsyncConnectionSource)source, (AsyncConnection)connection, connectionAndSourceReleasingCallback)));
    }

    static <R, T extends ReferenceCounted> void withAsyncSuppliedResource(AsyncCallbackSupplier<T> resourceSupplier, boolean wrapSourceConnectionException, SingleResultCallback<R> callback, AsyncCallbackFunction<T, R> function) throws OperationHelper.ResourceSupplierInternalException {
        SingleResultCallback errorHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        resourceSupplier.get((resource, supplierException) -> {
            if (supplierException != null) {
                if (wrapSourceConnectionException) {
                    supplierException = new OperationHelper.ResourceSupplierInternalException(supplierException);
                }
                errorHandlingCallback.onResult(null, supplierException);
            } else {
                Assertions.assertNotNull(resource);
                try {
                    AsyncCallbackSupplier curriedFunction = c -> function.apply(resource, c);
                    curriedFunction.whenComplete(resource::release).get(errorHandlingCallback);
                }
                catch (Exception e) {
                    errorHandlingCallback.onResult(null, e);
                }
            }
        });
    }

    static void withAsyncConnectionSourceCallableConnection(AsyncConnectionSource source, AsyncCallableWithConnection callable) {
        source.getConnection((connection, t) -> {
            source.release();
            if (t != null) {
                callable.call(null, t);
            } else {
                callable.call((AsyncConnection)connection, null);
            }
        });
    }

    static void withAsyncConnectionSource(AsyncConnectionSource source, AsyncCallableWithSource callable) {
        callable.call(source, null);
    }

    static <D, T> void executeRetryableReadAsync(AsyncReadBinding binding, String database, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> transformer, boolean retryReads, SingleResultCallback<T> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, binding::getReadConnectionSource, database, commandCreator, decoder, transformer, retryReads, callback);
    }

    static <D, T> void executeRetryableReadAsync(AsyncReadBinding binding, AsyncCallbackSupplier<AsyncConnectionSource> sourceAsyncSupplier, String database, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> transformer, boolean retryReads, SingleResultCallback<T> callback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(retryReads, binding.getOperationContext().getTimeoutContext());
        binding.retain();
        OperationContext operationContext = binding.getOperationContext();
        AsyncCallbackSupplier<T> asyncRead = AsyncOperationHelper.decorateReadWithRetriesAsync(retryState, binding.getOperationContext(), funcCallback -> AsyncOperationHelper.withAsyncSourceAndConnection(sourceAsyncSupplier, false, funcCallback, (source, connection, releasingCallback) -> {
            if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), operationContext), releasingCallback)) {
                return;
            }
            AsyncOperationHelper.createReadCommandAndExecuteAsync(retryState, operationContext, source, database, commandCreator, decoder, transformer, connection, releasingCallback);
        })).whenComplete(binding::release);
        asyncRead.get(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    static <T> void executeCommandAsync(AsyncWriteBinding binding, String database, CommandOperationHelper.CommandCreator commandCreator, CommandWriteTransformerAsync<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        Assertions.notNull("binding", binding);
        AsyncOperationHelper.withAsyncSourceAndConnection(binding::getWriteConnectionSource, false, callback, (source, connection, releasingCallback) -> AsyncOperationHelper.executeCommandAsync(binding, database, commandCreator.create(binding.getOperationContext(), source.getServerDescription(), connection.getDescription()), connection, transformer, releasingCallback));
    }

    static <T> void executeCommandAsync(AsyncWriteBinding binding, String database, BsonDocument command, AsyncConnection connection, CommandWriteTransformerAsync<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        Assertions.notNull("binding", binding);
        SingleResultCallback<T> addingRetryableLabelCallback = AsyncOperationHelper.addingRetryableLabelCallback(callback, connection.getDescription().getMaxWireVersion());
        connection.commandAsync(database, command, NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), new BsonDocumentCodec(), binding.getOperationContext(), AsyncOperationHelper.transformingWriteCallback(transformer, connection, addingRetryableLabelCallback));
    }

    static <T, R> void executeRetryableWriteAsync(AsyncWriteBinding binding, String database, @Nullable ReadPreference readPreference, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder, CommandOperationHelper.CommandCreator commandCreator, CommandWriteTransformerAsync<T, R> transformer, Function<BsonDocument, BsonDocument> retryCommandModifier, SingleResultCallback<R> callback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(true, binding.getOperationContext().getTimeoutContext());
        binding.retain();
        OperationContext operationContext = binding.getOperationContext();
        AsyncCallbackSupplier<R> asyncWrite = AsyncOperationHelper.decorateWriteWithRetriesAsync(retryState, operationContext, funcCallback -> {
            boolean firstAttempt = retryState.isFirstAttempt();
            if (!firstAttempt && operationContext.getSessionContext().hasActiveTransaction()) {
                operationContext.getSessionContext().clearTransactionContext();
            }
            AsyncOperationHelper.withAsyncSourceAndConnection(binding::getWriteConnectionSource, true, funcCallback, (source, connection, releasingCallback) -> {
                BsonDocument command;
                SingleResultCallback addingRetryableLabelCallback;
                int maxWireVersion = connection.getDescription().getMaxWireVersion();
                SingleResultCallback singleResultCallback = addingRetryableLabelCallback = firstAttempt ? releasingCallback : AsyncOperationHelper.addingRetryableLabelCallback(releasingCallback, maxWireVersion);
                if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryWrite(connection.getDescription(), operationContext.getSessionContext()), addingRetryableLabelCallback)) {
                    return;
                }
                try {
                    command = retryState.attachment(AttachmentKeys.command()).map(previousAttemptCommand -> {
                        Assertions.assertFalse(firstAttempt);
                        return (BsonDocument)retryCommandModifier.apply((BsonDocument)previousAttemptCommand);
                    }).orElseGet(() -> commandCreator.create(operationContext, source.getServerDescription(), connection.getDescription()));
                    retryState.attach(AttachmentKeys.maxWireVersion(), maxWireVersion, true).attach(AttachmentKeys.retryableCommandFlag(), CommandOperationHelper.isRetryWritesEnabled(command), true).attach(AttachmentKeys.commandDescriptionSupplier(), () -> ((BsonDocument)command).getFirstKey(), false).attach(AttachmentKeys.command(), command, false);
                }
                catch (Throwable t) {
                    addingRetryableLabelCallback.onResult(null, t);
                    return;
                }
                connection.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, operationContext, AsyncOperationHelper.transformingWriteCallback(transformer, connection, addingRetryableLabelCallback));
            });
        }).whenComplete(binding::release);
        asyncWrite.get(AsyncOperationHelper.exceptionTransformingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER)));
    }

    static <D, T> void createReadCommandAndExecuteAsync(RetryState retryState, OperationContext operationContext, AsyncConnectionSource source, String database, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> transformer, AsyncConnection connection, SingleResultCallback<T> callback) {
        BsonDocument command;
        try {
            command = commandCreator.create(operationContext, source.getServerDescription(), connection.getDescription());
            retryState.attach(AttachmentKeys.commandDescriptionSupplier(), () -> ((BsonDocument)command).getFirstKey(), false);
        }
        catch (IllegalArgumentException e) {
            callback.onResult(null, e);
            return;
        }
        connection.commandAsync(database, command, NoOpFieldNameValidator.INSTANCE, source.getReadPreference(), decoder, operationContext, AsyncOperationHelper.transformingReadCallback(transformer, source, connection, callback));
    }

    static <R> AsyncCallbackSupplier<R> decorateReadWithRetriesAsync(RetryState retryState, OperationContext operationContext, AsyncCallbackSupplier<R> asyncReadFunction) {
        return new RetryingAsyncCallbackSupplier(retryState, CommandOperationHelper.onRetryableReadAttemptFailure(operationContext), CommandOperationHelper::shouldAttemptToRetryRead, callback -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            asyncReadFunction.get(callback);
        });
    }

    static <R> AsyncCallbackSupplier<R> decorateWriteWithRetriesAsync(RetryState retryState, OperationContext operationContext, AsyncCallbackSupplier<R> asyncWriteFunction) {
        return new RetryingAsyncCallbackSupplier(retryState, CommandOperationHelper.onRetryableWriteAttemptFailure(operationContext), CommandOperationHelper::shouldAttemptToRetryWrite, callback -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            asyncWriteFunction.get(callback);
        });
    }

    static CommandWriteTransformerAsync<BsonDocument, Void> writeConcernErrorTransformerAsync(TimeoutContext timeoutContext) {
        return (result, connection) -> {
            Assertions.assertNotNull(result);
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion(), timeoutContext);
            return null;
        };
    }

    static <T> CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncSingleBatchCursorTransformer(String fieldName) {
        return (result, source, connection) -> new AsyncSingleBatchCursor(BsonDocumentWrapperHelper.toList(result, fieldName), 0);
    }

    static <T> AsyncBatchCursor<T> cursorDocumentToAsyncBatchCursor(TimeoutMode timeoutMode, BsonDocument cursorDocument, int batchSize, Decoder<T> decoder, BsonValue comment, AsyncConnectionSource source, AsyncConnection connection) {
        return new AsyncCommandBatchCursor<T>(timeoutMode, cursorDocument, batchSize, 0L, decoder, comment, source, connection);
    }

    static <T> SingleResultCallback<T> releasingCallback(SingleResultCallback<T> wrapped, AsyncConnection connection) {
        return new ReferenceCountedReleasingWrappedCallback<T>(wrapped, Collections.singletonList(connection));
    }

    static <R> SingleResultCallback<R> exceptionTransformingCallback(SingleResultCallback<R> callback) {
        return (result, t) -> {
            if (t != null) {
                if (t instanceof MongoException) {
                    callback.onResult(null, CommandOperationHelper.transformWriteException((MongoException)t));
                } else {
                    callback.onResult(null, t);
                }
            } else {
                callback.onResult(result, null);
            }
        };
    }

    private static <T, R> SingleResultCallback<T> transformingWriteCallback(CommandWriteTransformerAsync<T, R> transformer, AsyncConnection connection, SingleResultCallback<R> callback) {
        return (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                Object transformedResult;
                try {
                    transformedResult = transformer.apply(Assertions.assertNotNull(result), connection);
                }
                catch (Throwable e) {
                    callback.onResult(null, e);
                    return;
                }
                callback.onResult(transformedResult, null);
            }
        };
    }

    private static <R> SingleResultCallback<R> addingRetryableLabelCallback(SingleResultCallback<R> callback, int maxWireVersion) {
        return (result, t) -> {
            if (t != null) {
                if (t instanceof MongoException) {
                    CommandOperationHelper.addRetryableWriteErrorLabel((MongoException)t, maxWireVersion);
                }
                callback.onResult(null, t);
            } else {
                callback.onResult(result, null);
            }
        };
    }

    private static <T, R> SingleResultCallback<T> transformingReadCallback(CommandReadTransformerAsync<T, R> transformer, AsyncConnectionSource source, AsyncConnection connection, SingleResultCallback<R> callback) {
        return (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                Object transformedResult;
                try {
                    transformedResult = transformer.apply(Assertions.assertNotNull(result), source, connection);
                }
                catch (Throwable e) {
                    callback.onResult(null, e);
                    return;
                }
                callback.onResult(transformedResult, null);
            }
        };
    }

    private AsyncOperationHelper() {
    }

    private static class AsyncCallableWithSourceCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithSource callable;

        AsyncCallableWithSourceCallback(AsyncCallableWithSource callable) {
            this.callable = callable;
        }

        @Override
        public void onResult(@Nullable AsyncConnectionSource source, @Nullable Throwable t) {
            if (t != null) {
                this.callable.call(null, t);
            } else {
                AsyncOperationHelper.withAsyncConnectionSource(Assertions.assertNotNull(source), this.callable);
            }
        }
    }

    static interface AsyncCallableWithSource {
        public void call(@Nullable AsyncConnectionSource var1, @Nullable Throwable var2);
    }

    private static class AsyncCallableWithConnectionCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithConnection callable;

        AsyncCallableWithConnectionCallback(AsyncCallableWithConnection callable) {
            this.callable = callable;
        }

        @Override
        public void onResult(@Nullable AsyncConnectionSource source, @Nullable Throwable t) {
            if (t != null) {
                this.callable.call(null, t);
            } else {
                AsyncOperationHelper.withAsyncConnectionSourceCallableConnection(Assertions.assertNotNull(source), this.callable);
            }
        }
    }

    static interface AsyncCallableWithConnection {
        public void call(@Nullable AsyncConnection var1, @Nullable Throwable var2);
    }

    static interface CommandReadTransformerAsync<T, R> {
        @Nullable
        public R apply(T var1, AsyncConnectionSource var2, AsyncConnection var3);
    }

    static interface CommandWriteTransformerAsync<T, R> {
        @Nullable
        public R apply(T var1, AsyncConnection var2);
    }

    private static class ReferenceCountedReleasingWrappedCallback<T>
    implements SingleResultCallback<T> {
        private final SingleResultCallback<T> wrapped;
        private final List<? extends ReferenceCounted> referenceCounted;

        ReferenceCountedReleasingWrappedCallback(SingleResultCallback<T> wrapped, List<? extends ReferenceCounted> referenceCounted) {
            this.wrapped = wrapped;
            this.referenceCounted = Assertions.notNull("referenceCounted", referenceCounted);
        }

        @Override
        public void onResult(@Nullable T result, @Nullable Throwable t) {
            for (ReferenceCounted referenceCounted : this.referenceCounted) {
                if (referenceCounted == null) continue;
                referenceCounted.release();
            }
            this.wrapped.onResult(result, t);
        }
    }

    static interface AsyncCallableConnectionWithCallback<T> {
        public void call(AsyncConnection var1, SingleResultCallback<T> var2);
    }
}

