/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.socks;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequest;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty.handler.codec.socksx.v5.Socks5CommandType;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequest;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5Message;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequest;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.proxy.socks.Socks5ConnectHandler;
import org.mockserver.proxy.socks.SocksProxyHandler;

@ChannelHandler.Sharable
public class Socks5ProxyHandler
extends SocksProxyHandler<Socks5Message> {
    public Socks5ProxyHandler(LifeCycle server, MockServerLogger mockServerLogger) {
        super(server, mockServerLogger);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Socks5Message socksRequest) {
        if (socksRequest instanceof Socks5InitialRequest) {
            this.handleInitialRequest(ctx, (Socks5InitialRequest)socksRequest);
        } else if (socksRequest instanceof Socks5PasswordAuthRequest) {
            this.handlePasswordAuthRequest(ctx, (Socks5PasswordAuthRequest)socksRequest);
        } else if (socksRequest instanceof Socks5CommandRequest) {
            this.handleCommandRequest(ctx, (Socks5CommandRequest)socksRequest);
        } else {
            ctx.close();
        }
    }

    private void handleInitialRequest(ChannelHandlerContext ctx, Socks5InitialRequest initialRequest) {
        Socks5CommandRequestDecoder nextRequestDecoder;
        Socks5AuthMethod requiredAuthMethod;
        String username = ConfigurationProperties.proxyAuthenticationUsername();
        String password = ConfigurationProperties.proxyAuthenticationPassword();
        if (!username.isEmpty() && !password.isEmpty()) {
            requiredAuthMethod = Socks5AuthMethod.PASSWORD;
            nextRequestDecoder = new Socks5PasswordAuthRequestDecoder();
        } else {
            requiredAuthMethod = Socks5AuthMethod.NO_AUTH;
            nextRequestDecoder = new Socks5CommandRequestDecoder();
        }
        this.answerInitialRequest(ctx, initialRequest, requiredAuthMethod, (ChannelHandler)nextRequestDecoder);
    }

    private void answerInitialRequest(ChannelHandlerContext ctx, Socks5InitialRequest initialRequest, Socks5AuthMethod requiredAuthMethod, ChannelHandler nextRequestDecoder) {
        ctx.pipeline().remove(Socks5InitialRequestDecoder.class);
        for (Socks5AuthMethod authMethod : initialRequest.authMethods()) {
            if (!requiredAuthMethod.equals((Object)authMethod)) continue;
            ctx.pipeline().addFirst(new ChannelHandler[]{nextRequestDecoder});
            ctx.write((Object)new DefaultSocks5InitialResponse(requiredAuthMethod));
            return;
        }
        ctx.write((Object)new DefaultSocks5InitialResponse(Socks5AuthMethod.UNACCEPTED));
    }

    private void handlePasswordAuthRequest(ChannelHandlerContext ctx, Socks5PasswordAuthRequest passwordAuthRequest) {
        String username = ConfigurationProperties.proxyAuthenticationUsername();
        String password = ConfigurationProperties.proxyAuthenticationPassword();
        if (!username.isEmpty() && !password.isEmpty() && username.equals(passwordAuthRequest.username()) && password.equals(passwordAuthRequest.password())) {
            ctx.pipeline().replace(Socks5PasswordAuthRequestDecoder.class, null, (ChannelHandler)new Socks5CommandRequestDecoder());
            ctx.write((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.SUCCESS));
        } else {
            ctx.writeAndFlush((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.FAILURE)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void handleCommandRequest(ChannelHandlerContext ctx, Socks5CommandRequest commandRequest) {
        if (commandRequest.type().equals((Object)Socks5CommandType.CONNECT)) {
            this.forwardConnection(ctx, (ChannelHandler)new Socks5ConnectHandler(this.server, this.mockServerLogger, commandRequest.dstAddr(), commandRequest.dstPort()), commandRequest.dstAddr(), commandRequest.dstPort());
            ctx.fireChannelRead((Object)commandRequest);
        } else {
            ctx.writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.COMMAND_UNSUPPORTED, Socks5AddressType.DOMAIN, "", 0)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

