/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http.relay;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.proxy.http.relay.DirectClientHandler;
import org.mockserver.proxy.http.relay.ProxyRelayHandler;
import org.mockserver.proxy.interceptor.RequestInterceptor;
import org.mockserver.proxy.interceptor.ResponseInterceptor;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public abstract class RelayConnectHandler<T>
extends SimpleChannelInboundHandler<T> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Bootstrap bootstrap = new Bootstrap();
    private final InetSocketAddress connectSocket;
    private final boolean secure;

    public RelayConnectHandler(InetSocketAddress connectSocket, boolean secure) {
        if (connectSocket == null) {
            throw new IllegalArgumentException("Connect Socket can not be null");
        }
        this.connectSocket = connectSocket;
        this.secure = secure;
    }

    public void channelRead0(final ChannelHandlerContext ctx, final T request) throws Exception {
        final Promise promise = ctx.executor().newPromise();
        promise.addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

            public void operationComplete(Future<Channel> future) throws Exception {
                final Channel outboundChannel = (Channel)future.getNow();
                if (future.isSuccess()) {
                    ctx.channel().writeAndFlush(RelayConnectHandler.this.successResponse(request)).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            RelayConnectHandler.this.removeCodecSupport(ctx);
                            if (RelayConnectHandler.this.secure) {
                                SSLEngine clientEngine = SSLFactory.getInstance().sslContext().createSSLEngine();
                                clientEngine.setUseClientMode(true);
                                outboundChannel.pipeline().addLast("outbound relay ssl", (ChannelHandler)new SslHandler(clientEngine));
                            }
                            Logger outboundLogger = LoggerFactory.getLogger((String)"                -->");
                            if (RelayConnectHandler.this.logger.isDebugEnabled()) {
                                outboundChannel.pipeline().addLast("outbound relay logger", (ChannelHandler)new LoggingHandler(outboundLogger));
                            }
                            outboundChannel.pipeline().addLast(new ChannelHandler[]{new ProxyRelayHandler(ctx.channel(), 0x100000, new RequestInterceptor(null), outboundLogger)});
                            if (RelayConnectHandler.this.secure) {
                                SSLEngine serverEngine = SSLFactory.getInstance().sslContext().createSSLEngine();
                                serverEngine.setUseClientMode(false);
                                ctx.channel().pipeline().addLast("upstream relay ssl", (ChannelHandler)new SslHandler(serverEngine));
                            }
                            Logger inboundLogger = LoggerFactory.getLogger((String)"<-- ");
                            if (RelayConnectHandler.this.logger.isDebugEnabled()) {
                                ctx.channel().pipeline().addLast("upstream relay logger", (ChannelHandler)new LoggingHandler(inboundLogger));
                            }
                            ctx.channel().pipeline().addLast(new ChannelHandler[]{new ProxyRelayHandler(outboundChannel, 0x100000, new ResponseInterceptor(), inboundLogger)});
                        }
                    });
                } else {
                    RelayConnectHandler.this.failure("Failed to activate handler and retrieve channel", future.cause(), ctx, RelayConnectHandler.this.failureResponse(request));
                }
            }
        });
        Channel inboundChannel = ctx.channel();
        ((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)inboundChannel.eventLoop())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel socketChannel) throws Exception {
                socketChannel.pipeline().addLast(DirectClientHandler.class.getSimpleName(), (ChannelHandler)new DirectClientHandler((Promise<Channel>)promise));
            }
        });
        this.bootstrap.connect((SocketAddress)this.connectSocket).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    RelayConnectHandler.this.failure("Connection failed to 127.0.0.1:" + RelayConnectHandler.this.connectSocket, future.cause(), ctx, RelayConnectHandler.this.failureResponse(request));
                }
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.failure("Exception caught by http proxy CONNECT handler closing pipeline", cause, ctx, this.failureResponse(null));
    }

    private void failure(String message, Throwable cause, ChannelHandlerContext ctx, Object response) {
        this.logger.warn(message, cause);
        Channel channel = ctx.channel();
        channel.writeAndFlush(response);
        if (channel.isActive()) {
            channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected abstract void removeCodecSupport(ChannelHandlerContext var1);

    protected abstract Object successResponse(Object var1);

    protected abstract Object failureResponse(Object var1);
}

