/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.socks.SocksAuthResponse;
import io.netty.handler.codec.socks.SocksAuthScheme;
import io.netty.handler.codec.socks.SocksAuthStatus;
import io.netty.handler.codec.socks.SocksCmdRequest;
import io.netty.handler.codec.socks.SocksCmdRequestDecoder;
import io.netty.handler.codec.socks.SocksCmdType;
import io.netty.handler.codec.socks.SocksInitResponse;
import io.netty.handler.codec.socks.SocksRequest;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.http.ApacheHttpClient;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.mappers.MockServerToNettyResponseMapper;
import org.mockserver.mappers.NettyToMockServerRequestMapper;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NettyHttpRequest;
import org.mockserver.proxy.filters.Filters;
import org.mockserver.proxy.filters.HopByHopHeaderFilter;
import org.mockserver.proxy.filters.LogFilter;
import org.mockserver.proxy.filters.ProxyRequestFilter;
import org.mockserver.proxy.filters.ProxyResponseFilter;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.proxy.http.connect.HttpConnectHandler;
import org.mockserver.proxy.http.socks.SocksConnectHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProxyHandler
extends SimpleChannelInboundHandler<Object> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final InetSocketAddress connectSocket;
    private final boolean secure;
    private final HttpProxy server;
    private final LogFilter logFilter;
    private final Filters filters = new Filters();
    private final ApacheHttpClient apacheHttpClient = new ApacheHttpClient(true);
    private NettyToMockServerRequestMapper nettyToMockServerRequestMapper = new NettyToMockServerRequestMapper();
    private MockServerToNettyResponseMapper mockServerToNettyResponseMapper = new MockServerToNettyResponseMapper();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private NettyHttpRequest mockServerHttpRequest = null;
    private io.netty.handler.codec.http.HttpRequest request = null;

    public HttpProxyHandler(LogFilter logFilter, HttpProxy server, InetSocketAddress connectSocket, boolean secure) {
        this.logFilter = logFilter;
        this.server = server;
        this.connectSocket = connectSocket;
        this.secure = secure;
        this.filters.withFilter(new HttpRequest(), (ProxyRequestFilter)new HopByHopHeaderFilter());
        this.filters.withFilter(new HttpRequest(), (ProxyResponseFilter)logFilter);
    }

    public HttpProxyHandler withFilter(HttpRequest httpRequest, ProxyRequestFilter filter) {
        this.filters.withFilter(httpRequest, filter);
        return this;
    }

    public HttpProxyHandler withFilter(HttpRequest httpRequest, ProxyResponseFilter filter) {
        this.filters.withFilter(httpRequest, filter);
        return this;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpObject && ((HttpObject)msg).getDecoderResult().isSuccess()) {
            if (msg instanceof io.netty.handler.codec.http.HttpRequest) {
                this.request = (io.netty.handler.codec.http.HttpRequest)msg;
                String uri = this.request.getUri();
                if (uri.contains(this.request.headers().get("Host"))) {
                    uri = StringUtils.substringAfter((String)uri, (String)this.request.headers().get("Host"));
                }
                this.mockServerHttpRequest = new NettyHttpRequest(this.request.getProtocolVersion(), this.request.getMethod(), uri, this.secure);
                this.mockServerHttpRequest.headers().add(this.request.headers());
            }
            if (msg instanceof HttpContent && this.mockServerHttpRequest != null) {
                ByteBuf content = ((HttpContent)msg).content();
                if (content.isReadable()) {
                    this.mockServerHttpRequest.content(content);
                }
                if (msg instanceof LastHttpContent) {
                    LastHttpContent trailer = (LastHttpContent)msg;
                    if (!trailer.trailingHeaders().isEmpty()) {
                        this.mockServerHttpRequest.headers().entries().addAll(trailer.trailingHeaders().entries());
                    }
                    if (this.connectSocket != null && this.mockServerHttpRequest.getMethod() == HttpMethod.CONNECT) {
                        ctx.pipeline().addAfter(ctx.name(), HttpConnectHandler.class.getSimpleName(), (ChannelHandler)new HttpConnectHandler(this.connectSocket, true));
                        ctx.pipeline().remove((ChannelHandler)this);
                        ctx.fireChannelRead((Object)this.request);
                    } else if (this.mockServerHttpRequest.matches(HttpMethod.PUT, "/stop")) {
                        this.writeResponse(ctx, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED), HttpHeaders.isKeepAlive((HttpMessage)this.request));
                        ctx.close();
                        if (this.server != null) {
                            this.server.stop();
                        } else {
                            System.exit(0);
                        }
                    } else {
                        this.writeResponse(ctx, this.mockResponse(this.mockServerHttpRequest), HttpHeaders.isKeepAlive((HttpMessage)this.request));
                    }
                }
            }
        } else if (msg instanceof SocksRequest) {
            SocksRequest socksRequest = (SocksRequest)msg;
            switch (socksRequest.requestType()) {
                case INIT: {
                    ctx.pipeline().addFirst(SocksCmdRequestDecoder.getName(), (ChannelHandler)new SocksCmdRequestDecoder());
                    ctx.write((Object)new SocksInitResponse(SocksAuthScheme.NO_AUTH));
                    break;
                }
                case AUTH: {
                    ctx.pipeline().addFirst(SocksCmdRequestDecoder.getName(), (ChannelHandler)new SocksCmdRequestDecoder());
                    ctx.write((Object)new SocksAuthResponse(SocksAuthStatus.SUCCESS));
                    break;
                }
                case CMD: {
                    SocksCmdRequest req = (SocksCmdRequest)socksRequest;
                    if (req.cmdType() == SocksCmdType.CONNECT) {
                        ctx.pipeline().addLast(SocksConnectHandler.class.getSimpleName(), (ChannelHandler)new SocksConnectHandler(this.connectSocket, this.secure));
                        ctx.pipeline().remove((ChannelHandler)this);
                        ctx.fireChannelRead((Object)socksRequest);
                        break;
                    }
                    ctx.close();
                    break;
                }
                case UNKNOWN: {
                    ctx.close();
                }
            }
        } else {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, FullHttpResponse response, boolean isKeepAlive) {
        if (isKeepAlive) {
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            response.headers().set("Connection", (Object)"keep-alive");
        }
        ctx.write((Object)response);
        ctx.flush();
    }

    private FullHttpResponse mockResponse(NettyHttpRequest nettyHttpRequest) {
        if (nettyHttpRequest.matches(HttpMethod.PUT, "/dumpToLog")) {
            List<String> typeValues = nettyHttpRequest.parameters().get("type");
            boolean asJava = typeValues != null && !typeValues.isEmpty() && "java".equals(typeValues.get(0));
            this.logFilter.dumpToLog(nettyHttpRequest.content() != null ? this.httpRequestSerializer.deserialize(nettyHttpRequest.content().toString(CharsetUtil.UTF_8)) : null, asJava);
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED);
        }
        if (nettyHttpRequest.matches(HttpMethod.PUT, "/reset")) {
            this.logFilter.reset();
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED);
        }
        if (nettyHttpRequest.matches(HttpMethod.PUT, "/clear")) {
            HttpRequest httpRequest = this.httpRequestSerializer.deserialize(nettyHttpRequest.content().toString(CharsetUtil.UTF_8));
            this.logFilter.clear(httpRequest);
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED);
        }
        if (nettyHttpRequest.matches(HttpMethod.PUT, "/retrieve")) {
            Expectation[] expectations = this.logFilter.retrieve(this.httpRequestSerializer.deserialize(nettyHttpRequest.content() != null ? nettyHttpRequest.content().toString(CharsetUtil.UTF_8) : ""));
            String serialize = this.expectationSerializer.serialize(expectations);
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((byte[])serialize.getBytes()));
        }
        return this.forwardRequest(nettyHttpRequest);
    }

    private FullHttpResponse forwardRequest(NettyHttpRequest request) {
        return this.sendRequest(this.filters.applyFilters(this.nettyToMockServerRequestMapper.mapNettyRequestToMockServerRequest(request)));
    }

    private FullHttpResponse sendRequest(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpResponse httpResponse = this.filters.applyFilters(httpRequest, this.apacheHttpClient.sendRequest(httpRequest));
            return this.mockServerToNettyResponseMapper.mapMockServerResponseToNettyResponse(httpResponse);
        }
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.warn("Exception caught by http proxy handler closing pipeline", cause);
        ctx.close();
    }
}

