/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.mappers.MockServerToNettyResponseMapper;
import org.mockserver.mappers.NettyToMockServerRequestMapper;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mockserver.MockServer;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NettyHttpRequest;
import org.mockserver.proxy.filters.LogFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServerHandler
extends SimpleChannelInboundHandler<Object> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MockServerMatcher mockServerMatcher;
    private final LogFilter logFilter;
    private final boolean secure;
    private final MockServer server;
    private NettyToMockServerRequestMapper nettyToMockServerRequestMapper = new NettyToMockServerRequestMapper();
    private MockServerToNettyResponseMapper mockServerToNettyResponseMapper = new MockServerToNettyResponseMapper();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private NettyHttpRequest mockServerHttpRequest = null;
    private HttpRequest request = null;

    public MockServerHandler(MockServerMatcher mockServerMatcher, LogFilter logFilter, MockServer server, boolean secure) {
        this.mockServerMatcher = mockServerMatcher;
        this.logFilter = logFilter;
        this.server = server;
        this.secure = secure;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpObject && ((HttpObject)msg).getDecoderResult().isSuccess()) {
            if (msg instanceof HttpRequest) {
                this.request = (HttpRequest)msg;
                this.mockServerHttpRequest = new NettyHttpRequest(this.request.getProtocolVersion(), this.request.getMethod(), this.request.getUri(), this.secure);
                this.mockServerHttpRequest.headers().add(this.request.headers());
            }
            if (msg instanceof HttpContent && this.mockServerHttpRequest != null) {
                ByteBuf content = ((HttpContent)msg).content();
                if (content.isReadable()) {
                    this.mockServerHttpRequest.content(content);
                }
                if (msg instanceof LastHttpContent) {
                    LastHttpContent trailer = (LastHttpContent)msg;
                    if (!trailer.trailingHeaders().isEmpty()) {
                        this.mockServerHttpRequest.headers().entries().addAll(trailer.trailingHeaders().entries());
                    }
                    if (this.mockServerHttpRequest.matches(HttpMethod.PUT, "/stop")) {
                        this.writeResponse(ctx, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED), HttpHeaders.isKeepAlive((HttpMessage)this.request));
                        ctx.close();
                        this.server.stop();
                    } else {
                        this.writeResponse(ctx, this.mockResponse(this.mockServerHttpRequest), HttpHeaders.isKeepAlive((HttpMessage)this.request));
                    }
                }
            }
        } else {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, FullHttpResponse response, boolean isKeepAlive) {
        if (isKeepAlive) {
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            response.headers().set("Connection", (Object)"keep-alive");
        }
        ctx.write((Object)response);
        ctx.flush();
    }

    private FullHttpResponse mockResponse(NettyHttpRequest nettyHttpRequest) {
        String content;
        String string = content = nettyHttpRequest.content() != null ? nettyHttpRequest.content().toString(CharsetUtil.UTF_8) : "";
        if (nettyHttpRequest.matches(HttpMethod.PUT, "/dumpToLog")) {
            this.mockServerMatcher.dumpToLog(this.httpRequestSerializer.deserialize(content));
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED);
        }
        if (nettyHttpRequest.matches(HttpMethod.PUT, "/reset")) {
            this.logFilter.reset();
            this.mockServerMatcher.reset();
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED);
        }
        if (nettyHttpRequest.matches(HttpMethod.PUT, "/clear")) {
            org.mockserver.model.HttpRequest httpRequest = this.httpRequestSerializer.deserialize(content);
            this.logFilter.clear(httpRequest);
            this.mockServerMatcher.clear(httpRequest);
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED);
        }
        if (nettyHttpRequest.matches(HttpMethod.PUT, "/expectation")) {
            Expectation expectation = this.expectationSerializer.deserialize(content);
            this.mockServerMatcher.when(expectation.getHttpRequest(), expectation.getTimes()).thenRespond(expectation.getHttpResponse());
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CREATED);
        }
        if (nettyHttpRequest.matches(HttpMethod.PUT, "/retrieve")) {
            Expectation[] expectations = this.logFilter.retrieve(this.httpRequestSerializer.deserialize(content));
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((byte[])this.expectationSerializer.serialize(expectations).getBytes()));
        }
        org.mockserver.model.HttpRequest httpRequest = this.nettyToMockServerRequestMapper.mapNettyRequestToMockServerRequest(nettyHttpRequest);
        HttpResponse httpResponse = this.mockServerMatcher.handle(httpRequest);
        this.logFilter.onResponse(httpRequest, httpResponse);
        return this.mockServerToNettyResponseMapper.mapMockServerResponseToNettyResponse(httpResponse);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.warn("Exception caught by MockServer handler closing pipeline", cause);
        ctx.close();
    }
}

